/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.abe.core.entities;

import com.rcore.commons.utils.StringUtils;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FullName {
    protected String firstName;
    protected String middleName;
    protected String lastName;

    public FullName(String firstName, String middleName, String lastName) {
        this.firstName = firstName != null ? firstName : "";
        this.middleName = middleName != null ? middleName : "";
        this.lastName = lastName != null ? lastName : "";
    }

    public FullName() {
        this.firstName = "";
        this.middleName = "";
        this.lastName = "";
    }

    public static FullName of(String firstName, String middleName, String lastName) {
        return new FullName(firstName, middleName, lastName);
    }

    public static FullName empty() {
        return new FullName("", "", "");
    }

    public String toString() {
        return Stream.of(this.firstName, this.lastName, this.middleName).filter(StringUtils::hasText).collect(Collectors.joining(" "));
    }

    public boolean isEmpty() {
        return !StringUtils.hasText((String)this.firstName) && !StringUtils.hasText((String)this.middleName) && !StringUtils.hasText((String)this.lastName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullName fullName = (FullName)o;
        return Objects.equals(this.firstName, fullName.firstName) && Objects.equals(this.middleName, fullName.middleName) && Objects.equals(this.lastName, fullName.lastName);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.middleName, this.lastName);
    }

    protected FullName(FullNameBuilder<?, ?> b) {
        this.firstName = b.firstName;
        this.middleName = b.middleName;
        this.lastName = b.lastName;
    }

    public static FullNameBuilder<?, ?> builder() {
        return new FullNameBuilderImpl();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public static abstract class FullNameBuilder<C extends FullName, B extends FullNameBuilder<C, B>> {
        private String firstName;
        private String middleName;
        private String lastName;

        protected abstract B self();

        public abstract C build();

        public B firstName(String firstName) {
            this.firstName = firstName;
            return this.self();
        }

        public B middleName(String middleName) {
            this.middleName = middleName;
            return this.self();
        }

        public B lastName(String lastName) {
            this.lastName = lastName;
            return this.self();
        }

        public String toString() {
            return "FullName.FullNameBuilder(firstName=" + this.firstName + ", middleName=" + this.middleName + ", lastName=" + this.lastName + ")";
        }
    }

    private static final class FullNameBuilderImpl
    extends FullNameBuilder<FullName, FullNameBuilderImpl> {
        private FullNameBuilderImpl() {
        }

        @Override
        protected FullNameBuilderImpl self() {
            return this;
        }

        @Override
        public FullName build() {
            return new FullName(this);
        }
    }
}

