/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.abe.core.entities;

import com.google.i18n.phonenumbers.NumberParseException;
import ru.foodtechlab.abe.core.entities.PhoneNumber;

public enum CountryCode {
    RUSSIA(7, "RU", "Russian Federation", "+7 ([000]) [000] [00] [00]", 11),
    USA(1, "US", "United States of America", "+1 ([000]) [000]-[0000]", 11),
    CANADA(1, "CA", "Canada", "+1 ([000]) [000]-[0000]", 11),
    UNITED_ARAB_EMIRATES(971, "AE", "United Arab Emirates", "+(971 [00]) [000] [00] [00]", 12);

    private final Integer prefix;
    private final String prefixString;
    private final String countryCode;
    private final String countryName;
    private final String phoneMask;
    private final int phoneLength;

    private CountryCode(Integer prefix, String countryCode, String countryName, String phoneMask, int phoneLength) {
        this.prefix = prefix;
        this.prefixString = String.valueOf(prefix);
        this.countryCode = countryCode;
        this.countryName = countryName;
        this.phoneMask = phoneMask;
        this.phoneLength = phoneLength;
    }

    public static CountryCode parse(String phoneNumber) throws NumberParseException {
        String formatted = PhoneNumber.format(phoneNumber);
        for (CountryCode countryCode : CountryCode.values()) {
            if (!formatted.startsWith(countryCode.prefixString())) continue;
            return countryCode;
        }
        throw new NumberParseException(NumberParseException.ErrorType.INVALID_COUNTRY_CODE, "CountryCode parse exception");
    }

    public Integer prefix() {
        return this.prefix;
    }

    public String prefixString() {
        return this.prefixString;
    }

    public String countryCode() {
        return this.countryCode;
    }

    public String countryName() {
        return this.countryName;
    }

    public String phoneMask() {
        return this.phoneMask;
    }

    public int phoneLength() {
        return this.phoneLength;
    }
}

