/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.abe.core.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SortedData<T>
implements Iterable<T> {
    protected List<Position<T>> values = new ArrayList<Position<T>>();
    protected String firstElementId;
    protected String lastElementId;

    public static <T> SortedData<T> empty() {
        return new SortedData<T>();
    }

    public static <T> SortedData<T> of(Collection<T> list) {
        SortedData<T> data = new SortedData<T>();
        list.forEach(data::add);
        return data;
    }

    public boolean removeIf(Predicate<? super T> filter) {
        List<Object> values = this.stream().filter(filter).collect(Collectors.toList());
        values.forEach(this::delete);
        return values.size() > 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Position<T> currentPosition = null;

            @Override
            public boolean hasNext() {
                if (this.currentPosition == null && SortedData.this.firstElementId != null) {
                    return true;
                }
                if (this.currentPosition != null) {
                    return this.currentPosition.next != null;
                }
                return false;
            }

            @Override
            public T next() throws IndexOutOfBoundsException {
                if (!this.hasNext()) {
                    throw new IndexOutOfBoundsException("End of list.");
                }
                this.currentPosition = this.currentPosition == null ? SortedData.this.getById(SortedData.this.firstElementId) : SortedData.this.getById(this.currentPosition.getNext());
                return this.currentPosition.element;
            }
        };
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Iterable.super.forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return Iterable.super.spliterator();
    }

    public SortedData<T> add(T element) {
        Position<T> newElement;
        if (this.isNewInvalid(element)) {
            return this;
        }
        Position<T> lastElement = this.getById(this.lastElementId);
        if (lastElement == null) {
            newElement = Position.empty(element);
            this.firstElementId = newElement.id;
        } else {
            newElement = Position.last(lastElement.id, element);
            lastElement.setNext(newElement.id);
        }
        this.values.add(newElement);
        this.lastElementId = newElement.id;
        return this;
    }

    public SortedData<T> addStart(T element) {
        Position<T> newPosition;
        if (this.isNewInvalid(element)) {
            return this;
        }
        Position<T> position = this.getById(this.firstElementId);
        if (position == null) {
            newPosition = Position.empty(element);
            this.values.add(newPosition);
            this.lastElementId = newPosition.id;
        } else {
            newPosition = Position.first(position.id, element);
            position.setPrev(newPosition.id);
            this.values.add(newPosition);
        }
        this.firstElementId = newPosition.id;
        return this;
    }

    private boolean isNewInvalid(T element) {
        if (element == null) {
            return false;
        }
        return this.exist(element);
    }

    private boolean isExistedInvalid(T element) {
        if (element == null) {
            return false;
        }
        return !this.exist(element);
    }

    public boolean contains(T element) {
        return this.exist(element);
    }

    public SortedData<T> addAfter(T element, T after) {
        if (this.isNewInvalid(element)) {
            return this;
        }
        if (this.isExistedInvalid(after)) {
            return this;
        }
        boolean isAfterLast = this.getById((String)this.lastElementId).element.equals(after);
        if (isAfterLast) {
            this.add(element);
            return this;
        }
        Position<T> afterElement = this.get(after);
        Position<T> newElement = Position.middle(afterElement.id, afterElement.next, element);
        this.values.add(newElement);
        afterElement.next = newElement.id;
        return this;
    }

    public SortedData<T> addBefore(T element, T before) {
        if (this.isNewInvalid(element)) {
            return this;
        }
        if (this.isExistedInvalid(before)) {
            return this;
        }
        boolean isAfterLast = this.getById((String)this.firstElementId).element.equals(before);
        if (isAfterLast) {
            this.addStart(element);
            return this;
        }
        Position<T> beforeElement = this.get(before);
        Position<T> newPosition = Position.middle(beforeElement.prev, beforeElement.id, element);
        this.values.add(newPosition);
        beforeElement.prev = newPosition.id;
        return this;
    }

    public SortedData<T> delete(T element) {
        if (this.isExistedInvalid(element)) {
            return this;
        }
        if (this.values.size() == 0) {
            this.firstElementId = null;
            this.lastElementId = null;
        }
        Position<T> position = this.get(element);
        Position<T> prev = this.getById(position.prev);
        Position<T> next = this.getById(position.next);
        if (prev != null) {
            prev.next = position.next;
        } else {
            this.firstElementId = next != null ? next.id : null;
        }
        if (next != null) {
            next.prev = position.prev;
        } else {
            this.lastElementId = prev != null ? prev.id : null;
        }
        this.values.remove(position);
        return this;
    }

    private boolean exist(T element) {
        return this.get(element) != null;
    }

    private Position<T> get(T element) {
        return this.values.stream().filter(v -> v.element.equals(element)).findFirst().orElse(null);
    }

    private Position<T> getById(String id) {
        return this.values.stream().filter(v -> v.id.equals(id)).findFirst().orElse(null);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public List<T> asList() {
        ArrayList result = new ArrayList();
        this.forEach(result::add);
        return result;
    }

    public List<Position<T>> getValues() {
        return this.values;
    }

    public String getFirstElementId() {
        return this.firstElementId;
    }

    public String getLastElementId() {
        return this.lastElementId;
    }

    public void setValues(List<Position<T>> values) {
        this.values = values;
    }

    public void setFirstElementId(String firstElementId) {
        this.firstElementId = firstElementId;
    }

    public void setLastElementId(String lastElementId) {
        this.lastElementId = lastElementId;
    }

    public static class Position<T> {
        protected String id;
        protected String prev;
        protected String next;
        protected T element;

        private static String generateId() {
            return UUID.randomUUID().toString();
        }

        private static <T> Position<T> last(String prev, T element) {
            return new Position<T>(Position.generateId(), prev, null, element);
        }

        private static <T> Position<T> first(String next, T element) {
            return new Position<T>(Position.generateId(), null, next, element);
        }

        private static <T> Position<T> middle(String prev, String next, T element) {
            return new Position<T>(Position.generateId(), prev, next, element);
        }

        private static <T> Position<T> empty(T element) {
            return new Position<T>(Position.generateId(), null, null, element);
        }

        public String getId() {
            return this.id;
        }

        public String getPrev() {
            return this.prev;
        }

        public String getNext() {
            return this.next;
        }

        public T getElement() {
            return this.element;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setPrev(String prev) {
            this.prev = prev;
        }

        public void setNext(String next) {
            this.next = next;
        }

        public void setElement(T element) {
            this.element = element;
        }

        public Position() {
        }

        public Position(String id, String prev, String next, T element) {
            this.id = id;
            this.prev = prev;
            this.next = next;
            this.element = element;
        }
    }
}

