/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.abe.core.entities;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.IsoFields;
import java.util.Date;

public class DateTimeObject {
    Integer year;
    Integer month;
    Integer day;
    Integer hour;
    Integer minute;
    Integer second;
    DayOfWeek dayOfWeek;
    Integer week;
    Instant instant;
    String timeZone;

    public static DateTimeObject of(Instant instant, ZoneId zone) {
        int year = instant.atZone(zone).getYear();
        int month = instant.atZone(zone).getMonth().getValue();
        int dayOfMonth = instant.atZone(zone).getDayOfMonth();
        int hour = instant.atZone(zone).getHour();
        int minute = instant.atZone(zone).getMinute();
        int second = instant.atZone(zone).getSecond();
        DayOfWeek dayOfWeek = instant.atZone(zone).getDayOfWeek();
        int weekOfYear = instant.atZone(zone).get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
        String timeZone = zone.getId();
        return DateTimeObject.builder().year(year).month(month).day(dayOfMonth).hour(hour).minute(minute).dayOfWeek(dayOfWeek).week(weekOfYear).second(second).instant(instant).timeZone(timeZone).build();
    }

    public static DateTimeObject of(ZonedDateTime zonedDateTime) {
        return DateTimeObject.of(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    public static DateTimeObject of(Date date, ZoneId zone) {
        return DateTimeObject.of(date.toInstant(), zone);
    }

    public static DateTimeObject of(Long mills, ZoneId zone) {
        return DateTimeObject.of(Instant.ofEpochMilli(mills), zone);
    }

    public static ZonedDateTime getZonedDateTime(DateTimeObject dateTimeObject) {
        return dateTimeObject.instant.atZone(ZoneId.of(dateTimeObject.timeZone));
    }

    public ZonedDateTime toZonedDateTime() {
        return DateTimeObject.getZonedDateTime(this);
    }

    public static DateTimeObjectBuilder builder() {
        return new DateTimeObjectBuilder();
    }

    public DateTimeObject(Integer year, Integer month, Integer day, Integer hour, Integer minute, Integer second, DayOfWeek dayOfWeek, Integer week, Instant instant, String timeZone) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.dayOfWeek = dayOfWeek;
        this.week = week;
        this.instant = instant;
        this.timeZone = timeZone;
    }

    public DateTimeObject() {
    }

    public Integer getYear() {
        return this.year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getDay() {
        return this.day;
    }

    public Integer getHour() {
        return this.hour;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public Integer getSecond() {
        return this.second;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public Integer getWeek() {
        return this.week;
    }

    public Instant getInstant() {
        return this.instant;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public static class DateTimeObjectBuilder {
        private Integer year;
        private Integer month;
        private Integer day;
        private Integer hour;
        private Integer minute;
        private Integer second;
        private DayOfWeek dayOfWeek;
        private Integer week;
        private Instant instant;
        private String timeZone;

        DateTimeObjectBuilder() {
        }

        public DateTimeObjectBuilder year(Integer year) {
            this.year = year;
            return this;
        }

        public DateTimeObjectBuilder month(Integer month) {
            this.month = month;
            return this;
        }

        public DateTimeObjectBuilder day(Integer day) {
            this.day = day;
            return this;
        }

        public DateTimeObjectBuilder hour(Integer hour) {
            this.hour = hour;
            return this;
        }

        public DateTimeObjectBuilder minute(Integer minute) {
            this.minute = minute;
            return this;
        }

        public DateTimeObjectBuilder second(Integer second) {
            this.second = second;
            return this;
        }

        public DateTimeObjectBuilder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public DateTimeObjectBuilder week(Integer week) {
            this.week = week;
            return this;
        }

        public DateTimeObjectBuilder instant(Instant instant) {
            this.instant = instant;
            return this;
        }

        public DateTimeObjectBuilder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public DateTimeObject build() {
            return new DateTimeObject(this.year, this.month, this.day, this.hour, this.minute, this.second, this.dayOfWeek, this.week, this.instant, this.timeZone);
        }

        public String toString() {
            return "DateTimeObject.DateTimeObjectBuilder(year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", second=" + this.second + ", dayOfWeek=" + this.dayOfWeek + ", week=" + this.week + ", instant=" + this.instant + ", timeZone=" + this.timeZone + ")";
        }
    }
}

