/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.abe.core.entities;

import com.google.i18n.phonenumbers.NumberParseException;
import ru.foodtechlab.abe.core.entities.PhoneNumber;

public enum CountryCode {
    RUSSIA(7, "RU", "Russian Federation"),
    USA(1, "US", "United States of America"),
    CANADA(1, "CA", "Canada"),
    UNITED_ARAB_EMIRATES(971, "AE", "United Arab Emirates");

    private final Integer prefix;
    private final String prefixString;
    private final String countryCode;
    private final String countryName;

    private CountryCode(Integer prefix, String countryCode, String countryName) {
        this.prefix = prefix;
        this.prefixString = String.valueOf(prefix);
        this.countryCode = countryCode;
        this.countryName = countryName;
    }

    public static CountryCode parse(String phoneNumber) throws NumberParseException {
        String formatted = PhoneNumber.format(phoneNumber);
        for (CountryCode countryCode : CountryCode.values()) {
            if (!formatted.startsWith(countryCode.prefixString())) continue;
            return countryCode;
        }
        throw new NumberParseException(NumberParseException.ErrorType.INVALID_COUNTRY_CODE, "CountryCode parse exception");
    }

    public Integer prefix() {
        return this.prefix;
    }

    public String prefixString() {
        return this.prefixString;
    }

    public String countryCode() {
        return this.countryCode;
    }

    public String countryName() {
        return this.countryName;
    }
}

