/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fnproject.fn.api.Headers;
import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.runtime.EventCodec;
import com.fnproject.fn.testing.FnEventBuilder;
import com.fnproject.fn.testing.FnEventBuilderJUnit4;
import com.fnproject.fn.testing.FnHttpEventBuilder;
import com.fnproject.fn.testing.FnResult;
import com.fnproject.fn.testing.FnTestingClassLoader;
import com.fnproject.fn.testing.FnTestingRuleFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class FnTestingRule
implements TestRule {
    private final Map<String, String> config = new HashMap<String, String>();
    private Map<String, String> eventEnv = new HashMap<String, String>();
    private boolean hasEvents = false;
    private List<InputEvent> pendingInput = Collections.synchronizedList(new ArrayList());
    private List<FnResult> output = Collections.synchronizedList(new ArrayList());
    private ByteArrayOutputStream stdErr = new ByteArrayOutputStream();
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final List<String> sharedPrefixes = new ArrayList<String>();
    private int lastExitCode;
    private final List<FnTestingRuleFeature> features = new ArrayList<FnTestingRuleFeature>();

    private FnTestingRule() {
        this.addSharedClassPrefix("java.");
        this.addSharedClassPrefix("javax.");
        this.addSharedClassPrefix("sun.");
        this.addSharedClassPrefix("jdk.");
        this.addSharedClass(Headers.class);
        this.addSharedClass(InputEvent.class);
        this.addSharedClass(OutputEvent.class);
        this.addSharedClass(OutputEvent.Status.class);
        this.addSharedClass(TestOutput.class);
        this.addSharedClass(TestCodec.class);
        this.addSharedClass(EventCodec.class);
        this.addSharedClass(EventCodec.Handler.class);
    }

    public void addFeature(FnTestingRuleFeature f) {
        this.features.add(f);
    }

    public static FnTestingRule createDefault() {
        return new FnTestingRule();
    }

    public FnTestingRule setConfig(String key, String value) {
        this.config.put(key.toUpperCase().replaceAll("[- ]", "_"), value);
        return this;
    }

    public FnTestingRule addSharedClassPrefix(String prefix) {
        this.sharedPrefixes.add(prefix);
        return this;
    }

    public FnTestingRule addSharedClass(Class<?> cls) {
        this.sharedPrefixes.add("=" + cls.getName());
        return this;
    }

    public Statement apply(Statement base, Description description) {
        return base;
    }

    public FnEventBuilderJUnit4 givenEvent() {
        return new DefaultFnEventBuilder();
    }

    public void thenRun(Class<?> cls, String method) {
        this.thenRun(cls.getName(), method);
    }

    public void thenRun(String cls, String method) {
        Class<?> c = null;
        try {
            c = Class.forName(cls);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClassLoader functionClassLoader = c != null ? c.getClassLoader() : this.getClass().getClassLoader();
        PrintStream oldSystemOut = System.out;
        PrintStream oldSystemErr = System.err;
        for (FnTestingRuleFeature f : this.features) {
            f.prepareTest(functionClassLoader, oldSystemErr, cls, method);
        }
        HashMap<String, String> mutableEnv = new HashMap<String, String>();
        try {
            PrintStream functionErr = new PrintStream((OutputStream)new TeeOutputStream((OutputStream)this.stdErr, (OutputStream)oldSystemErr));
            System.setOut(functionErr);
            System.setErr(functionErr);
            mutableEnv.putAll(this.config);
            mutableEnv.putAll(this.eventEnv);
            mutableEnv.put("FN_FORMAT", "http-stream");
            mutableEnv.put("FN_FN_ID", "myFnID");
            mutableEnv.put("FN_APP_ID", "myAppID");
            FnTestingClassLoader forked = new FnTestingClassLoader(functionClassLoader, this.sharedPrefixes);
            if (forked.isShared(cls)) {
                oldSystemErr.println("WARNING: The function class under test is shared with the test ClassLoader.");
                oldSystemErr.println("         This may result in unexpected behaviour around function initialization and configuration.");
            }
            for (FnTestingRuleFeature f : this.features) {
                f.prepareFunctionClassLoader(forked);
            }
            TestCodec codec = new TestCodec(this.pendingInput, this.output);
            this.lastExitCode = forked.run(mutableEnv, (EventCodec)codec, functionErr, new String[]{cls + "::" + method});
            this.stdErr.flush();
            for (FnTestingRuleFeature f : this.features) {
                f.afterTestComplete();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("internal error raised by entry point or flushing the test streams", e);
        }
        finally {
            System.out.flush();
            System.err.flush();
            System.setOut(oldSystemOut);
            System.setErr(oldSystemErr);
        }
    }

    public int getLastExitCode() {
        return this.lastExitCode;
    }

    public byte[] getStdErr() {
        return this.stdErr.toByteArray();
    }

    public String getStdErrAsString() {
        return new String(this.stdErr.toByteArray());
    }

    public List<FnResult> getResults() {
        return this.output;
    }

    public FnResult getOnlyResult() {
        List<FnResult> results = this.getResults();
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new IllegalStateException("One and only one response expected, but " + results.size() + " responses were generated.");
    }

    public List<String> getSharedPrefixes() {
        return Collections.unmodifiableList(this.sharedPrefixes);
    }

    public Map<String, String> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public Map<String, String> getEventEnv() {
        return Collections.unmodifiableMap(this.eventEnv);
    }

    private class DefaultFnEventBuilder
    implements FnEventBuilderJUnit4 {
        FnHttpEventBuilder builder = new FnHttpEventBuilder();

        private DefaultFnEventBuilder() {
        }

        public FnEventBuilder withHeader(String key, String value) {
            this.builder.withHeader(key, value);
            return this;
        }

        public FnEventBuilder withBody(InputStream body) throws IOException {
            this.builder.withBody(body);
            return this;
        }

        public FnEventBuilder withBody(byte[] body) {
            this.builder.withBody(body);
            return this;
        }

        public FnEventBuilder withBody(String body) {
            this.builder.withBody(body);
            return this;
        }

        public FnTestingRule enqueue() {
            FnTestingRule.this.pendingInput.add(this.builder.buildEvent());
            return FnTestingRule.this;
        }

        public FnTestingRule enqueue(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Invalid count");
            }
            for (int i = 0; i < n; ++i) {
                this.enqueue();
            }
            return FnTestingRule.this;
        }
    }

    public static class TestCodec
    implements EventCodec {
        private final List<InputEvent> input;
        private final List<FnResult> output;

        public TestCodec(List<InputEvent> input, List<FnResult> output) {
            this.input = input;
            this.output = output;
        }

        public void runCodec(EventCodec.Handler h) {
            for (InputEvent in : this.input) {
                try {
                    this.output.add(new TestOutput(h.handle(in)));
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected exception in test", e);
                }
            }
        }
    }

    public static final class TestOutput
    implements FnResult {
        private final OutputEvent from;
        byte[] body;

        private TestOutput(OutputEvent from) throws IOException {
            this.from = Objects.requireNonNull(from, "from");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            from.writeToOutput((OutputStream)bos);
            this.body = bos.toByteArray();
        }

        public static TestOutput fromOutputEvent(OutputEvent from) throws IOException {
            return new TestOutput(from);
        }

        public OutputEvent.Status getStatus() {
            return this.from.getStatus();
        }

        public Optional<String> getContentType() {
            return this.from.getContentType();
        }

        public Headers getHeaders() {
            return this.from.getHeaders();
        }

        public void writeToOutput(OutputStream out) throws IOException {
            out.write(this.body);
        }

        public byte[] getBodyAsBytes() {
            return this.body;
        }

        public String getBodyAsString() {
            return new String(this.body);
        }
    }
}

