/*
 * Decompiled with CFR 0.152.
 */
package io.fluidsonic.stdlib;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0018"}, d2={"Lio/fluidsonic/stdlib/SemanticVersion;", "", "major", "", "minor", "patch", "(III)V", "getMajor", "()I", "getMinor", "getPatch", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "fluid-stdlib"})
@SourceDebugExtension(value={"SMAP\nSemanticVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticVersion.kt\nio/fluidsonic/stdlib/SemanticVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class SemanticVersion
implements Comparable<SemanticVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private static final Regex pattern = new Regex("(0|[1-9]\\d*)(?:\\.(0|[1-9]\\d*)(?:\\.(0|[1-9]\\d*))?)?");

    public SemanticVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        if (!(this.major >= 0)) {
            boolean $i$a$-require-SemanticVersion$42 = false;
            String $i$a$-require-SemanticVersion$42 = "major must not be negative";
            throw new IllegalArgumentException($i$a$-require-SemanticVersion$42.toString());
        }
        if (!(this.minor >= 0)) {
            boolean $i$a$-require-SemanticVersion$52 = false;
            String $i$a$-require-SemanticVersion$52 = "minor must not be negative";
            throw new IllegalArgumentException($i$a$-require-SemanticVersion$52.toString());
        }
        if (!(this.patch >= 0)) {
            boolean bl = false;
            String string = "patch must not be negative";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SemanticVersion(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3);
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(@NotNull SemanticVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int majorComparison = Intrinsics.compare((int)this.major, (int)other.major);
        if (majorComparison != 0) {
            return majorComparison;
        }
        int minorComparison = Intrinsics.compare((int)this.minor, (int)other.minor);
        if (minorComparison != 0) {
            return minorComparison;
        }
        return Intrinsics.compare((int)this.patch, (int)other.patch);
    }

    @NotNull
    public String toString() {
        return "" + this.major + '.' + this.minor + '.' + this.patch;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final SemanticVersion copy(int major, int minor, int patch) {
        return new SemanticVersion(major, minor, patch);
    }

    public static /* synthetic */ SemanticVersion copy$default(SemanticVersion semanticVersion, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = semanticVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = semanticVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = semanticVersion.patch;
        }
        return semanticVersion.copy(n, n2, n3);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion semanticVersion = (SemanticVersion)other;
        if (this.major != semanticVersion.major) {
            return false;
        }
        if (this.minor != semanticVersion.minor) {
            return false;
        }
        return this.patch == semanticVersion.patch;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/fluidsonic/stdlib/SemanticVersion$Companion;", "", "()V", "pattern", "Lkotlin/text/Regex;", "parse", "Lio/fluidsonic/stdlib/SemanticVersion;", "string", "", "fluid-stdlib"})
    @SourceDebugExtension(value={"SMAP\nSemanticVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticVersion.kt\nio/fluidsonic/stdlib/SemanticVersion$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SemanticVersion parse(@NotNull String string) {
            SemanticVersion semanticVersion;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            MatchResult matchResult = pattern.matchEntire((CharSequence)string);
            if (matchResult == null) {
                return null;
            }
            MatchResult match = matchResult;
            try {
                CharSequence charSequence;
                CharSequence charSequence2;
                int n;
                int n2 = Integer.parseInt((String)match.getGroupValues().get(1));
                CharSequence charSequence3 = (CharSequence)match.getGroupValues().get(2);
                if (charSequence3.length() == 0) {
                    n = n2;
                    boolean bl = false;
                    Object var7_7 = null;
                    n2 = n;
                    charSequence2 = var7_7;
                } else {
                    charSequence2 = charSequence3;
                }
                String string2 = (String)charSequence2;
                int n3 = string2 != null ? Integer.parseInt(string2) : 0;
                charSequence3 = (CharSequence)match.getGroupValues().get(3);
                if (charSequence3.length() == 0) {
                    int n4 = n3;
                    n = n2;
                    boolean bl = false;
                    Object var8_9 = null;
                    n2 = n;
                    n3 = n4;
                    charSequence = var8_9;
                } else {
                    charSequence = charSequence3;
                }
                String string3 = (String)charSequence;
                int n5 = string3 != null ? Integer.parseInt(string3) : 0;
                int n6 = n3;
                int n7 = n2;
                semanticVersion = new SemanticVersion(n7, n6, n5);
            }
            catch (IllegalArgumentException e) {
                semanticVersion = null;
            }
            return semanticVersion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

