/*
 * Decompiled with CFR 0.152.
 */
package io.fluidsonic.stdlib;

import io.fluidsonic.stdlib.MathKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lio/fluidsonic/stdlib/GeoCoordinate;", "", "latitude", "", "longitude", "(DD)V", "getLatitude", "()D", "getLongitude", "component1", "component2", "copy", "distanceTo", "coordinate", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "fluid-stdlib"})
public final class GeoCoordinate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double latitude;
    private final double longitude;
    private static final double earthRadius = 6378137.0;

    public GeoCoordinate(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        double d = this.latitude;
        if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
            boolean $i$a$-require-GeoCoordinate$32 = false;
            String $i$a$-require-GeoCoordinate$32 = "latitude must be a finite value";
            throw new IllegalArgumentException($i$a$-require-GeoCoordinate$32.toString());
        }
        d = this.longitude;
        if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
            boolean $i$a$-require-GeoCoordinate$42 = false;
            String $i$a$-require-GeoCoordinate$42 = "longitude must be a finite value";
            throw new IllegalArgumentException($i$a$-require-GeoCoordinate$42.toString());
        }
        GeoCoordinate $this$freeze$iv = this;
        boolean $i$f$freeze = false;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final double distanceTo(@NotNull GeoCoordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        double sinHalfLatitudeDistance = Math.sin(MathKt.degreesToRadians(coordinate.latitude - this.latitude) * 0.5);
        double sinHalfLongitudeDistance = Math.sin(MathKt.degreesToRadians(coordinate.longitude - this.longitude) * 0.5);
        double a = sinHalfLatitudeDistance * sinHalfLatitudeDistance + Math.cos(MathKt.degreesToRadians(this.latitude)) * Math.cos(MathKt.degreesToRadians(coordinate.latitude)) * sinHalfLongitudeDistance * sinHalfLongitudeDistance;
        double d = Math.sqrt(a);
        double d2 = Math.sqrt(1.0 - a);
        double b = (double)2 * Math.atan2(d, d2);
        return 6378137.0 * b;
    }

    @NotNull
    public String toString() {
        return "" + this.latitude + ',' + this.longitude;
    }

    public final double component1() {
        return this.latitude;
    }

    public final double component2() {
        return this.longitude;
    }

    @NotNull
    public final GeoCoordinate copy(double latitude, double longitude) {
        return new GeoCoordinate(latitude, longitude);
    }

    public static /* synthetic */ GeoCoordinate copy$default(GeoCoordinate geoCoordinate, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = geoCoordinate.latitude;
        }
        if ((n & 2) != 0) {
            d2 = geoCoordinate.longitude;
        }
        return geoCoordinate.copy(d, d2);
    }

    public int hashCode() {
        int result = Double.hashCode(this.latitude);
        result = result * 31 + Double.hashCode(this.longitude);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeoCoordinate)) {
            return false;
        }
        GeoCoordinate geoCoordinate = (GeoCoordinate)other;
        if (!Intrinsics.areEqual((Object)this.latitude, (Object)geoCoordinate.latitude)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.longitude, (Object)geoCoordinate.longitude);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/fluidsonic/stdlib/GeoCoordinate$Companion;", "", "()V", "earthRadius", "", "fluid-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

