/*
 * Decompiled with CFR 0.152.
 */
package io.fluidsonic.stdlib;

import io.fluidsonic.stdlib.MathKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lio/fluidsonic/stdlib/GeoCoordinate;", "", "latitude", "", "longitude", "(DD)V", "getLatitude", "()D", "getLongitude", "component1", "component2", "copy", "distanceTo", "coordinate", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "fluid-stdlib"})
public final class GeoCoordinate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double latitude;
    private final double longitude;
    private static final double earthRadius = 6378137.0;

    /*
     * Unable to fully structure code
     */
    public GeoCoordinate(double latitude, double longitude) {
        super();
        this.latitude = latitude;
        this.longitude = longitude;
        var5_3 = this.latitude;
        var7_8 = false;
        var8_11 = var5_3;
        var10_14 = false;
        if (Double.isInfinite(var8_11)) ** GOTO lbl-1000
        var8_11 = var5_3;
        var10_14 = false;
        if (!Double.isNaN(var8_11)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        var5_4 = v0;
        var6_15 = false;
        var7_8 = false;
        if (!var5_4) {
            $i$a$-require-GeoCoordinate$1 = false;
            var7_9 = "latitude must be a finite value";
            throw (Throwable)new IllegalArgumentException(var7_9.toString());
        }
        var5_5 = this.longitude;
        var7_8 = false;
        $i$a$-require-GeoCoordinate$1 = var5_5;
        var10_14 = false;
        if (Double.isInfinite($i$a$-require-GeoCoordinate$1)) ** GOTO lbl-1000
        $i$a$-require-GeoCoordinate$1 = var5_5;
        var10_14 = false;
        if (!Double.isNaN($i$a$-require-GeoCoordinate$1)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        var5_6 = v1;
        var6_15 = false;
        var7_8 = false;
        if (!var5_6) {
            $i$a$-require-GeoCoordinate$2 = false;
            var7_10 = "longitude must be a finite value";
            throw (Throwable)new IllegalArgumentException(var7_10.toString());
        }
        $this$freeze$iv = this;
        $i$f$freeze = false;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final double distanceTo(@NotNull GeoCoordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        double d = MathKt.degreesToRadians(coordinate.latitude - this.latitude) * 0.5;
        boolean bl = false;
        double sinHalfLatitudeDistance = Math.sin(d);
        double d2 = MathKt.degreesToRadians(coordinate.longitude - this.longitude) * 0.5;
        boolean bl2 = false;
        double sinHalfLongitudeDistance = Math.sin(d2);
        double d3 = MathKt.degreesToRadians(this.latitude);
        boolean bl3 = false;
        double d4 = Math.cos(d3);
        d3 = MathKt.degreesToRadians(coordinate.latitude);
        bl3 = false;
        double a = sinHalfLatitudeDistance * sinHalfLatitudeDistance + d4 * Math.cos(d3) * sinHalfLongitudeDistance * sinHalfLongitudeDistance;
        bl3 = false;
        double d5 = Math.sqrt(a);
        double d6 = 1.0 - a;
        boolean bl4 = false;
        d6 = Math.sqrt(d6);
        bl4 = false;
        double b = (double)2 * Math.atan2(d5, d6);
        return 6378137.0 * b;
    }

    @NotNull
    public String toString() {
        return "" + this.latitude + ',' + this.longitude;
    }

    public final double component1() {
        return this.latitude;
    }

    public final double component2() {
        return this.longitude;
    }

    @NotNull
    public final GeoCoordinate copy(double latitude, double longitude) {
        return new GeoCoordinate(latitude, longitude);
    }

    public static /* synthetic */ GeoCoordinate copy$default(GeoCoordinate geoCoordinate, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = geoCoordinate.latitude;
        }
        if ((n & 2) != 0) {
            d2 = geoCoordinate.longitude;
        }
        return geoCoordinate.copy(d, d2);
    }

    public int hashCode() {
        int result = Double.hashCode(this.latitude);
        result = result * 31 + Double.hashCode(this.longitude);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeoCoordinate)) {
            return false;
        }
        GeoCoordinate geoCoordinate = (GeoCoordinate)other;
        if (!Intrinsics.areEqual((Object)this.latitude, (Object)geoCoordinate.latitude)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.longitude, (Object)geoCoordinate.longitude);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/fluidsonic/stdlib/GeoCoordinate$Companion;", "", "()V", "earthRadius", "", "fluid-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

