/*
 * Decompiled with CFR 0.152.
 */
package io.fluidsonic.stdlib;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0003j\u0002`\u0004\u001a\u001e\u0010\u0000\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0003j\u0002`\u00042\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a8\u0006\n"}, d2={"atEndOfDay", "Ljava/time/LocalDateTime;", "Lio/fluidsonic/stdlib/PlatformLocalDateTime;", "Ljava/time/LocalDate;", "Lio/fluidsonic/stdlib/PlatformLocalDate;", "Ljava/time/ZonedDateTime;", "Lio/fluidsonic/stdlib/PlatformZonedDateTime;", "zone", "Ljava/time/ZoneId;", "Lio/fluidsonic/stdlib/PlatformZoneId;", "fluid-stdlib"})
public final class PlatformLocalDate_jvmKt {
    @NotNull
    public static final LocalDateTime atEndOfDay(@NotNull LocalDate $this$atEndOfDay) {
        Intrinsics.checkParameterIsNotNull((Object)$this$atEndOfDay, (String)"$this$atEndOfDay");
        LocalDateTime localDateTime = $this$atEndOfDay.atTime(LocalTime.MAX);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"atTime(PlatformLocalTime.MAX)");
        return localDateTime;
    }

    @NotNull
    public static final ZonedDateTime atEndOfDay(@NotNull LocalDate $this$atEndOfDay, @NotNull ZoneId zone) {
        ZoneRules rules;
        ZoneOffsetTransition transition;
        Intrinsics.checkParameterIsNotNull((Object)$this$atEndOfDay, (String)"$this$atEndOfDay");
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        LocalDateTime localDateTime = $this$atEndOfDay.atTime(LocalTime.MAX);
        if (!(zone instanceof ZoneOffset) && (transition = (rules = zone.getRules()).getTransition(localDateTime)) != null && transition.isGap()) {
            localDateTime = transition.getDateTimeBefore();
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, zone);
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"PlatformZonedDateTime.of(localDateTime, zone)");
        return zonedDateTime;
    }
}

