/*
 * Decompiled with CFR 0.152.
 */
package io.fluidsonic.server;

import io.fluidsonic.server.PasswordHash;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001:\u000212B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J0\u0010 \u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001eH\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u001eH\u0002J \u0010+\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010.J\"\u0010+\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0016H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b/\u00100R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00063"}, d2={"Lio/fluidsonic/server/PasswordHasher;", "", "hashLength", "", "iterationCount", "saltLength", "(III)V", "HASH_ALGORITHM_INDEX", "HASH_SECTIONS", "HASH_SIZE_INDEX", "ITERATION_INDEX", "PBKDF2_INDEX", "SALT_INDEX", "algorithmId", "", "algorithms", "", "getHashLength", "()I", "getIterationCount", "getSaltLength", "createHash", "Lio/fluidsonic/server/PasswordHash;", "password", "Lio/fluidsonic/server/Password;", "createHash-tI5mZks", "(Ljava/lang/String;)Ljava/lang/String;", "", "([C)Ljava/lang/String;", "fromBase64", "", "hex", "pbkdf2", "salt", "iterations", "bytes", "algorithmName", "slowEquals", "", "a", "b", "toBase64", "array", "verifyPassword", "expectedHash", "verifyPassword-yRv1SWg", "(Ljava/lang/String;Ljava/lang/String;)Z", "verifyPassword-LQ3Ueis", "([CLjava/lang/String;)Z", "CannotPerformOperationException", "InvalidHashException", "fluid-server"})
public final class PasswordHasher {
    private final int HASH_SECTIONS = 5;
    private final int HASH_ALGORITHM_INDEX = 0;
    private final int ITERATION_INDEX = 1;
    private final int HASH_SIZE_INDEX = 2;
    private final int SALT_INDEX = 3;
    private final int PBKDF2_INDEX = 4;
    private final String algorithmId = "sha512";
    private final Map<String, String> algorithms;
    private final int hashLength;
    private final int iterationCount;
    private final int saltLength;

    @NotNull
    public final String createHash-tI5mZks(@NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        String string = password;
        PasswordHasher passwordHasher = this;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        return passwordHasher.createHash(cArray2);
    }

    private final String createHash(char[] password) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[this.saltLength];
        random.nextBytes(salt);
        byte[] hash = this.pbkdf2(password, salt, this.iterationCount, this.hashLength, (String)MapsKt.getValue(this.algorithms, (Object)this.algorithmId));
        int hashSize = hash.length;
        return PasswordHash.constructor-impl(this.algorithmId + ':' + this.iterationCount + ':' + hashSize + ':' + this.toBase64(salt) + ':' + this.toBase64(hash));
    }

    public final boolean verifyPassword-yRv1SWg(@NotNull String password, @NotNull String expectedHash) {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)expectedHash, (String)"expectedHash");
        String string = password;
        PasswordHasher passwordHasher = this;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        return passwordHasher.verifyPassword-LQ3Ueis(cArray2, expectedHash);
    }

    private final boolean verifyPassword-LQ3Ueis(char[] password, String expectedHash) {
        int e4;
        byte[] e22;
        byte[] e32;
        List list;
        CharSequence charSequence = expectedHash;
        String string = ":";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List $this$dropLastWhile$iv = string.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv22 = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv22.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] params = stringArray;
        if (params.length != this.HASH_SECTIONS) {
            throw (Throwable)new InvalidHashException("Fields are missing from the password hash.", null, 2, null);
        }
        String $i$f$toTypedArray22 = params[this.HASH_ALGORITHM_INDEX];
        int thisCollection$iv22 = 0;
        boolean it = false;
        String it2 = $i$f$toTypedArray22;
        boolean bl4 = false;
        String string2 = this.algorithms.get(it2);
        if (string2 == null) {
            throw (Throwable)new CannotPerformOperationException("Unsupported hash type: " + it2, null, 2, null);
        }
        String algorithmName = string2;
        try {
            thisCollection$iv22 = Integer.parseInt(params[this.ITERATION_INDEX]);
        }
        catch (NumberFormatException e32) {
            throw (Throwable)new InvalidHashException("Could not parse the iteration count as an integer.", e32);
        }
        int iterations = thisCollection$iv22;
        if (iterations < 1) {
            throw (Throwable)new InvalidHashException("Invalid number of iterations. Must be >= 1.", null, 2, null);
        }
        try {
            e32 = this.fromBase64(params[this.SALT_INDEX]);
        }
        catch (IllegalArgumentException e22) {
            throw (Throwable)new InvalidHashException("Base64 decoding of salt failed.", e22);
        }
        byte[] salt = e32;
        try {
            e22 = this.fromBase64(params[this.PBKDF2_INDEX]);
        }
        catch (IllegalArgumentException e4) {
            throw (Throwable)new InvalidHashException("Base64 decoding of pbkdf2 output failed.", e4);
        }
        byte[] hash = e22;
        try {
            e4 = Integer.parseInt(params[this.HASH_SIZE_INDEX]);
        }
        catch (NumberFormatException e5) {
            throw (Throwable)new InvalidHashException("Could not parse the hash size as an integer.", e5);
        }
        int storedHashSize = e4;
        if (storedHashSize != hash.length) {
            throw (Throwable)new InvalidHashException("Hash length doesn't match stored hash length.", null, 2, null);
        }
        byte[] testHash = this.pbkdf2(password, salt, iterations, hash.length, algorithmName);
        return this.slowEquals(hash, testHash);
    }

    private final boolean slowEquals(byte[] a, byte[] b) {
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            byte by = a[i];
            byte by2 = b[i];
            int n = diff;
            boolean bl = false;
            byte by3 = (byte)(by ^ by2);
            diff = n | by3;
        }
        return diff == 0;
    }

    private final byte[] pbkdf2(char[] password, byte[] salt, int iterations, int bytes, String algorithmName) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, bytes * 8);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithmName);
            SecretKey secretKey = skf.generateSecret(spec);
            Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"skf.generateSecret(spec)");
            byte[] byArray = secretKey.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"skf.generateSecret(spec).encoded");
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new CannotPerformOperationException("Hash algorithm not supported.", e);
        }
        catch (InvalidKeySpecException e) {
            throw (Throwable)new CannotPerformOperationException("Invalid key spec.", e);
        }
    }

    private final byte[] fromBase64(String hex) {
        byte[] byArray = Base64.getDecoder().decode(hex);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(hex)");
        return byArray;
    }

    private final String toBase64(byte[] array) {
        String string = Base64.getEncoder().encodeToString(array);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.getEncoder().encodeToString(array)");
        return string;
    }

    public final int getHashLength() {
        return this.hashLength;
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    public final int getSaltLength() {
        return this.saltLength;
    }

    public PasswordHasher(int hashLength, int iterationCount, int saltLength) {
        this.hashLength = hashLength;
        this.iterationCount = iterationCount;
        this.saltLength = saltLength;
        this.HASH_SECTIONS = 5;
        this.ITERATION_INDEX = 1;
        this.HASH_SIZE_INDEX = 2;
        this.SALT_INDEX = 3;
        this.PBKDF2_INDEX = 4;
        this.algorithmId = "sha512";
        this.algorithms = MapsKt.mapOf((Pair)TuplesKt.to((Object)"sha512", (Object)"PBKDF2WithHmacSHA512"));
        boolean bl = this.hashLength >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "hash length must be at least 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.iterationCount >= 1;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "iteration count must be at least 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.saltLength >= 1;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "salt length must be at least 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PasswordHasher(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 18;
        }
        if ((n4 & 2) != 0) {
            n2 = 64000;
        }
        if ((n4 & 4) != 0) {
            n3 = 24;
        }
        this(n, n2, n3);
    }

    public PasswordHasher() {
        this(0, 0, 0, 7, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/fluidsonic/server/PasswordHasher$InvalidHashException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "fluid-server"})
    private static final class InvalidHashException
    extends Exception {
        public InvalidHashException(@NotNull String message, @Nullable Throwable cause) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            super(message, cause);
        }

        public /* synthetic */ InvalidHashException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/fluidsonic/server/PasswordHasher$CannotPerformOperationException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "fluid-server"})
    private static final class CannotPerformOperationException
    extends Exception {
        public CannotPerformOperationException(@NotNull String message, @Nullable Throwable cause) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            super(message, cause);
        }

        public /* synthetic */ CannotPerformOperationException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }
    }
}

