package io.fluidsonic.server

import io.fluidsonic.json.AbstractJsonCodec
import io.fluidsonic.json.JsonCodingContext
import io.fluidsonic.json.JsonCodingType
import io.fluidsonic.json.JsonDecoder
import io.fluidsonic.json.JsonEncoder
import io.fluidsonic.json.missingPropertyError
import io.fluidsonic.json.readBooleanOrNull
import io.fluidsonic.json.readByteOrNull
import io.fluidsonic.json.readCharOrNull
import io.fluidsonic.json.readDoubleOrNull
import io.fluidsonic.json.readFloatOrNull
import io.fluidsonic.json.readFromMapByElementValue
import io.fluidsonic.json.readIntOrNull
import io.fluidsonic.json.readLongOrNull
import io.fluidsonic.json.readShortOrNull
import io.fluidsonic.json.readStringOrNull
import io.fluidsonic.json.readValueOfType
import io.fluidsonic.json.readValueOfTypeOrNull
import io.fluidsonic.json.writeBooleanOrNull
import io.fluidsonic.json.writeByteOrNull
import io.fluidsonic.json.writeCharOrNull
import io.fluidsonic.json.writeDoubleOrNull
import io.fluidsonic.json.writeFloatOrNull
import io.fluidsonic.json.writeIntOrNull
import io.fluidsonic.json.writeIntoMap
import io.fluidsonic.json.writeLongOrNull
import io.fluidsonic.json.writeMapElement
import io.fluidsonic.json.writeShortOrNull
import io.fluidsonic.json.writeStringOrNull
import io.fluidsonic.json.writeValueOrNull
import io.fluidsonic.stdlib.GeoCoordinate

internal object GeoCoordinateJsonCodec : AbstractJsonCodec<GeoCoordinate, JsonCodingContext>() {
	override fun JsonDecoder<JsonCodingContext>.decode(valueType: JsonCodingType<GeoCoordinate>):
			GeoCoordinate {
		var _latitude = 0.0
		var latitude_isPresent = false
		var _longitude = 0.0
		var longitude_isPresent = false

		readFromMapByElementValue { key ->
			when (key) {
				"latitude" ->  {
					_latitude = readDouble()
					latitude_isPresent = true
				}
				"longitude" ->  {
					_longitude = readDouble()
					longitude_isPresent = true
				}
				else -> skipValue()
			}
		}

		latitude_isPresent || missingPropertyError("latitude")
		longitude_isPresent || missingPropertyError("longitude")

		return GeoCoordinate(
			latitude = _latitude,
			longitude = _longitude
		)
	}

	override fun JsonEncoder<JsonCodingContext>.encode(value: GeoCoordinate) {
		writeIntoMap {
			writeMapElement("latitude", double = value.latitude)
			writeMapElement("longitude", double = value.longitude)
		}
	}
}
