package io.fluidsonic.server

import io.fluidsonic.json.AbstractJsonCodec
import io.fluidsonic.json.JsonCodingContext
import io.fluidsonic.json.JsonCodingType
import io.fluidsonic.json.JsonDecoder
import io.fluidsonic.json.JsonEncoder
import io.fluidsonic.json.readBooleanOrNull
import io.fluidsonic.json.readByteOrNull
import io.fluidsonic.json.readCharOrNull
import io.fluidsonic.json.readDoubleOrNull
import io.fluidsonic.json.readFloatOrNull
import io.fluidsonic.json.readIntOrNull
import io.fluidsonic.json.readLongOrNull
import io.fluidsonic.json.readShortOrNull
import io.fluidsonic.json.readStringOrNull
import io.fluidsonic.json.readValueOfType
import io.fluidsonic.json.readValueOfTypeOrNull
import io.fluidsonic.json.writeValueOrNull
import io.fluidsonic.stdlib.Cents

internal object CentsJsonCodec : AbstractJsonCodec<Cents, JsonCodingContext>() {
	override fun JsonDecoder<JsonCodingContext>.decode(valueType: JsonCodingType<Cents>): Cents =
			Cents(value = readLong())
	override fun JsonEncoder<JsonCodingContext>.encode(value: Cents) {
		writeLong(value.value)
	}
}
