/*
 * Decompiled with CFR 0.152.
 */
package io.fluidsonic.mongo;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ServerAddress;
import com.mongodb.TransactionOptions;
import com.mongodb.session.ServerSession;
import io.fluidsonic.mongo.ClientSession;
import io.fluidsonic.mongo.PublisherKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0011\u0010\u0014\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u000eH\u0016J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u0011H\u0016J\u0018\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u001aH\u0016J\b\u0010,\u001a\u00020\nH\u0016J\u0010\u0010,\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0006\u0010-\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006."}, d2={"Lio/fluidsonic/mongo/ReactiveCoroutineClientSession;", "Lio/fluidsonic/mongo/ClientSession;", "source", "Lcom/mongodb/reactivestreams/client/ClientSession;", "(Lcom/mongodb/reactivestreams/client/ClientSession;)V", "transactionOptions", "Lcom/mongodb/TransactionOptions;", "getTransactionOptions", "()Lcom/mongodb/TransactionOptions;", "abortTransaction", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "advanceClusterTime", "clusterTime", "Lorg/bson/BsonDocument;", "advanceOperationTime", "operationTime", "Lorg/bson/BsonTimestamp;", "clearTransactionContext", "close", "commitTransaction", "getClusterTime", "getOperationTime", "getOptions", "Lcom/mongodb/ClientSessionOptions;", "getOriginator", "", "getPinnedServerAddress", "Lcom/mongodb/ServerAddress;", "getRecoveryToken", "getServerSession", "Lcom/mongodb/session/ServerSession;", "getSnapshotTimestamp", "getTransactionContext", "hasActiveTransaction", "", "isCausallyConsistent", "setRecoveryToken", "recoveryToken", "setSnapshotTimestamp", "snapshotTimestamp", "setTransactionContext", "address", "transactionContext", "startTransaction", "unwrap", "fluid-mongo"})
public final class ReactiveCoroutineClientSession
implements ClientSession {
    @NotNull
    private final com.mongodb.reactivestreams.client.ClientSession source;

    public ReactiveCoroutineClientSession(@NotNull com.mongodb.reactivestreams.client.ClientSession source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    @Override
    @Nullable
    public Object abortTransaction(@NotNull Continuation<? super Unit> $completion) {
        Publisher publisher = this.source.abortTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"source.abortTransaction()");
        Object object = PublisherKt.awaitCompletion((Publisher<? extends Void>)publisher, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void advanceClusterTime(@NotNull BsonDocument clusterTime) {
        Intrinsics.checkNotNullParameter((Object)clusterTime, (String)"clusterTime");
        this.source.advanceClusterTime(clusterTime);
    }

    public void advanceOperationTime(@NotNull BsonTimestamp operationTime) {
        Intrinsics.checkNotNullParameter((Object)operationTime, (String)"operationTime");
        this.source.advanceOperationTime(operationTime);
    }

    public void clearTransactionContext() {
        this.source.clearTransactionContext();
    }

    public void close() {
        this.source.close();
    }

    @Override
    @Nullable
    public Object commitTransaction(@NotNull Continuation<? super Unit> $completion) {
        Publisher publisher = this.source.commitTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"source.commitTransaction()");
        Object object = PublisherKt.awaitCompletion((Publisher<? extends Void>)publisher, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public BsonDocument getClusterTime() {
        BsonDocument bsonDocument = this.source.getClusterTime();
        Intrinsics.checkNotNullExpressionValue((Object)bsonDocument, (String)"source.clusterTime");
        return bsonDocument;
    }

    @NotNull
    public BsonTimestamp getOperationTime() {
        BsonTimestamp bsonTimestamp = this.source.getOperationTime();
        Intrinsics.checkNotNullExpressionValue((Object)bsonTimestamp, (String)"source.operationTime");
        return bsonTimestamp;
    }

    @NotNull
    public ClientSessionOptions getOptions() {
        ClientSessionOptions clientSessionOptions = this.source.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)clientSessionOptions, (String)"source.options");
        return clientSessionOptions;
    }

    @NotNull
    public Object getOriginator() {
        Object object = this.source.getOriginator();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.originator");
        return object;
    }

    @Nullable
    public ServerAddress getPinnedServerAddress() {
        return this.source.getPinnedServerAddress();
    }

    @Nullable
    public BsonDocument getRecoveryToken() {
        return this.source.getRecoveryToken();
    }

    @NotNull
    public ServerSession getServerSession() {
        ServerSession serverSession = this.source.getServerSession();
        Intrinsics.checkNotNullExpressionValue((Object)serverSession, (String)"source.serverSession");
        return serverSession;
    }

    @Nullable
    public BsonTimestamp getSnapshotTimestamp() {
        return this.source.getSnapshotTimestamp();
    }

    @Nullable
    public Object getTransactionContext() {
        return this.source.getTransactionContext();
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.source.hasActiveTransaction();
    }

    public boolean isCausallyConsistent() {
        return this.source.isCausallyConsistent();
    }

    public void setRecoveryToken(@NotNull BsonDocument recoveryToken) {
        Intrinsics.checkNotNullParameter((Object)recoveryToken, (String)"recoveryToken");
        this.source.setRecoveryToken(recoveryToken);
    }

    public void setSnapshotTimestamp(@NotNull BsonTimestamp snapshotTimestamp) {
        Intrinsics.checkNotNullParameter((Object)snapshotTimestamp, (String)"snapshotTimestamp");
        this.source.setSnapshotTimestamp(snapshotTimestamp);
    }

    public void setTransactionContext(@NotNull ServerAddress address, @NotNull Object transactionContext) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)transactionContext, (String)"transactionContext");
        this.source.setTransactionContext(address, transactionContext);
    }

    @Override
    public void startTransaction() {
        this.source.startTransaction();
    }

    @Override
    public void startTransaction(@NotNull TransactionOptions transactionOptions) {
        Intrinsics.checkNotNullParameter((Object)transactionOptions, (String)"transactionOptions");
        this.source.startTransaction(transactionOptions);
    }

    @Override
    @NotNull
    public TransactionOptions getTransactionOptions() {
        TransactionOptions transactionOptions = this.source.getTransactionOptions();
        Intrinsics.checkNotNullExpressionValue((Object)transactionOptions, (String)"source.transactionOptions");
        return transactionOptions;
    }

    @NotNull
    public final com.mongodb.reactivestreams.client.ClientSession unwrap() {
        return this.source;
    }
}

