/*
 * Decompiled with CFR 0.152.
 */
package io.fluidsonic.json.annotationprocessor;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import io.fluidsonic.json.AbstractJsonCodec;
import io.fluidsonic.json.AbstractJsonDecoderCodec;
import io.fluidsonic.json.AbstractJsonEncoderCodec;
import io.fluidsonic.json.JsonCodingType;
import io.fluidsonic.json.JsonDecoder;
import io.fluidsonic.json.JsonEncoder;
import io.fluidsonic.json.annotationprocessor.KotlinpoetTypeNames;
import io.fluidsonic.json.annotationprocessor.KotlinpoetTypeNamesKt;
import io.fluidsonic.json.annotationprocessor.MQualifiedTypeNameKt;
import io.fluidsonic.json.annotationprocessor.ProcessingResult;
import io.fluidsonic.meta.MFunctionName;
import io.fluidsonic.meta.MPackageName;
import io.fluidsonic.meta.MPackageNameKt;
import io.fluidsonic.meta.MTypeNameKt;
import io.fluidsonic.meta.MValueParameter;
import io.fluidsonic.meta.MVariableName;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J$\u0010\u0016\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J$\u0010\u0017\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J$\u0010\u0018\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/fluidsonic/json/annotationprocessor/CodecGenerator;", "", "outputDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "generate", "", "codec", "Lio/fluidsonic/json/annotationprocessor/ProcessingResult$Codec;", "generateForSingleValueRepresentation", "generateForStructuredRepresentation", "methodNameForReadingValueOfType", "", "type", "Lcom/squareup/kotlinpoet/TypeName;", "methodNameForWritingValueOfType", "parameterNameForWritingValueOfType", "generateDecode", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "strategy", "Lio/fluidsonic/json/annotationprocessor/ProcessingResult$Codec$DecodingStrategy;", "valueType", "generateDecodeWithReflection", "generateDecodeWithoutReflection", "generateEncode", "Lio/fluidsonic/json/annotationprocessor/ProcessingResult$Codec$EncodingStrategy;", "Companion", "fluid-json-annotation-processor"})
public final class CodecGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File outputDirectory;
    @NotNull
    private static final ClassName codingType = TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(JsonCodingType.class));

    public CodecGenerator(@NotNull File outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        this.outputDirectory = outputDirectory;
    }

    public final void generate(@NotNull ProcessingResult.Codec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (codec.isSingleValue()) {
            this.generateForSingleValueRepresentation(codec);
        } else {
            this.generateForStructuredRepresentation(codec);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateForSingleValueRepresentation(ProcessingResult.Codec codec) {
        TypeSpec.Builder $this$generateForSingleValueRepresentation_u24lambda_u2d4;
        TypeSpec.Builder builder;
        void $this$applyIf$iv;
        Object[] objectArray;
        String typeName = StringsKt.replace$default((String)MTypeNameKt.getKotlin-x-WKhkU((String)io.fluidsonic.meta.MQualifiedTypeNameKt.withoutPackage-tsNLATY((String)codec.getName-NV_oo0w())), (char)'.', (char)'_', (boolean)false, (int)4, null);
        Object object = codec.getDecodingStrategy();
        ProcessingResult.Codec.DecodableProperty decodableProperty = object != null && (object = ((ProcessingResult.Codec.DecodingStrategy)object).getProperties()) != null ? (ProcessingResult.Codec.DecodableProperty)CollectionsKt.singleOrNull((Iterable)((Iterable)object)) : null;
        Object object2 = codec.getEncodingStrategy();
        ProcessingResult.Codec.EncodableProperty encodableProperty = object2 != null && (object2 = ((ProcessingResult.Codec.EncodingStrategy)object2).getProperties()) != null ? (ProcessingResult.Codec.EncodableProperty)CollectionsKt.singleOrNull((Iterable)((Iterable)object2)) : null;
        TypeName[] typeNameArray = new TypeName[]{(TypeName)MQualifiedTypeNameKt.forKotlinPoet-KwEpx3k$default(codec.getContextType-NV_oo0w(), false, 1, null)};
        ParameterizedTypeName decoderType = ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(JsonDecoder.class)), typeNameArray);
        TypeSpec.Builder builder2 = new TypeSpec.Builder[]{(TypeName)MQualifiedTypeNameKt.forKotlinPoet-KwEpx3k$default(codec.getContextType-NV_oo0w(), false, 1, null)};
        ParameterizedTypeName encoderType = ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(JsonEncoder.class)), (TypeName[])builder2);
        TypeSpec.Builder $this$generateForSingleValueRepresentation_u24lambda_u2d1 = builder2 = FileSpec.Companion.builder(MPackageNameKt.getKotlin-GNTwjs4((String)io.fluidsonic.meta.MQualifiedTypeNameKt.getPackageName-tsNLATY((String)codec.getName-NV_oo0w())), typeName).indent("\t");
        boolean bl = false;
        if (decodableProperty != null) {
            objectArray = new String[]{"readBooleanOrNull", "readByteOrNull", "readCharOrNull", "readDoubleOrNull", "readFloatOrNull", "readIntOrNull", "readLongOrNull", "readShortOrNull", "readStringOrNull", "readValueOfType", "readValueOfTypeOrNull"};
            $this$generateForSingleValueRepresentation_u24lambda_u2d1.addImport("io.fluidsonic.json", (String[])objectArray);
        }
        if (encodableProperty != null) {
            objectArray = new String[]{"writeValueOrNull"};
            $this$generateForSingleValueRepresentation_u24lambda_u2d1.addImport("io.fluidsonic.json", (String[])objectArray);
            String string = encodableProperty.getImportPackageName-lnPZ-7c();
            if (string != null) {
                String it = (string != null ? MPackageName.box-impl((String)string) : null).unbox-impl();
                boolean bl2 = false;
                String[] stringArray = new String[]{encodableProperty.getName-qHWkUaA()};
                $this$generateForSingleValueRepresentation_u24lambda_u2d1.addImport(MPackageNameKt.getKotlin-GNTwjs4((String)it), stringArray);
            }
        }
        TypeSpec.Builder builder3 = builder2;
        builder2 = TypeSpec.Companion.objectBuilder(typeName);
        boolean condition$iv22 = !codec.isPublic();
        boolean $i$f$applyIf = false;
        if (condition$iv22) {
            void $this$generateForSingleValueRepresentation_u24lambda_u2d2;
            objectArray = $this$applyIf$iv;
            builder = builder3;
            boolean bl3 = false;
            KModifier[] kModifierArray = new KModifier[]{KModifier.INTERNAL};
            $this$generateForSingleValueRepresentation_u24lambda_u2d2.addModifiers(kModifierArray);
            builder3 = builder;
        }
        builder2 = new TypeSpec.Builder[]{codec.getValueType(), (TypeName)MQualifiedTypeNameKt.forKotlinPoet-KwEpx3k$default(codec.getContextType-NV_oo0w(), false, 1, null)};
        TypeSpec.Builder condition$iv22 = builder2 = $this$applyIf$iv.superclass((TypeName)ParameterizedTypeName.Companion.get(TypeNames.get((KClass)(decodableProperty == null ? Reflection.getOrCreateKotlinClass(AbstractJsonEncoderCodec.class) : (encodableProperty == null ? Reflection.getOrCreateKotlinClass(AbstractJsonDecoderCodec.class) : Reflection.getOrCreateKotlinClass(AbstractJsonCodec.class)))), (TypeName[])builder2));
        builder = builder3;
        boolean bl4 = false;
        if (decodableProperty != null) {
            void $this$generateForSingleValueRepresentation_u24lambda_u2d4_u24lambda_u2d3;
            objectArray = new KModifier[]{KModifier.OVERRIDE};
            FunSpec.Builder builder4 = FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder("decode").addModifiers((KModifier[])objectArray), (TypeName)((TypeName)decoderType), null, (int)2, null);
            objectArray = new TypeName[]{codec.getValueType()};
            String[] bl3 = objectArray = FunSpec.Builder.returns$default((FunSpec.Builder)builder4.addParameter("valueType", (TypeName)ParameterizedTypeName.Companion.get(codingType, (TypeName[])objectArray), new KModifier[0]), (TypeName)codec.getValueType(), null, (int)2, null);
            void var12_17 = $this$generateForSingleValueRepresentation_u24lambda_u2d4;
            boolean bl5 = false;
            TypeName typeName2 = codec.getValueType();
            ParameterizedTypeName parameterizedTypeName = typeName2 instanceof ParameterizedTypeName ? (ParameterizedTypeName)typeName2 : null;
            TypeName rawValueType = parameterizedTypeName != null && (parameterizedTypeName = parameterizedTypeName.getRawType()) != null ? (TypeName)parameterizedTypeName : codec.getValueType();
            if (decodableProperty.getTypeParameterIndex() >= 0) {
                if (Intrinsics.areEqual((Object)decodableProperty.getType(), (Object)KotlinpoetTypeNames.INSTANCE.getAny()) || Intrinsics.areEqual((Object)decodableProperty.getType(), (Object)KotlinpoetTypeNames.INSTANCE.getNullableAny())) {
                    Object[] objectArray2 = new Object[]{rawValueType, MVariableName.toString-impl((String)decodableProperty.getName-qHWkUaA()), this.methodNameForReadingValueOfType(decodableProperty.getType()), decodableProperty.getTypeParameterIndex()};
                    $this$generateForSingleValueRepresentation_u24lambda_u2d4_u24lambda_u2d3.addCode("return %1T(%2N = %3N(valueType.arguments[%4L]))", objectArray2);
                } else {
                    Object[] objectArray3 = new Object[]{rawValueType, MVariableName.toString-impl((String)decodableProperty.getName-qHWkUaA()), this.methodNameForReadingValueOfType(decodableProperty.getType()), decodableProperty.getTypeParameterIndex(), decodableProperty.getType()};
                    $this$generateForSingleValueRepresentation_u24lambda_u2d4_u24lambda_u2d3.addCode("return %1T(%2N = %3N(valueType.arguments[%4L]) as %5T)", objectArray3);
                }
            } else {
                Object[] objectArray4 = new Object[]{rawValueType, MVariableName.toString-impl((String)decodableProperty.getName-qHWkUaA()), this.methodNameForReadingValueOfType(decodableProperty.getType())};
                $this$generateForSingleValueRepresentation_u24lambda_u2d4_u24lambda_u2d3.addCode("return %1T(%2N = %3N())", objectArray4);
            }
            var12_17.addFunction(objectArray.build());
        }
        $this$generateForSingleValueRepresentation_u24lambda_u2d4 = builder2;
        boolean bl6 = false;
        if (encodableProperty != null) {
            void $this$generateForSingleValueRepresentation_u24lambda_u2d5;
            objectArray = new KModifier[]{KModifier.OVERRIDE};
            FunSpec.Builder builder5 = FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder("encode").addModifiers((KModifier[])objectArray), (TypeName)((TypeName)encoderType), null, (int)2, null).addParameter("value", codec.getValueType(), new KModifier[0]);
            objectArray = new Object[]{this.methodNameForWritingValueOfType(encodableProperty.getType()), MVariableName.toString-impl((String)encodableProperty.getName-qHWkUaA())};
            $this$generateForSingleValueRepresentation_u24lambda_u2d5.addFunction(builder5.addCode("%1N(value.%2N)\n", objectArray).build());
        }
        builder.addType(builder2.build()).build().writeTo(this.outputDirectory);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateForStructuredRepresentation(ProcessingResult.Codec codec) {
        void $this$generateForStructuredRepresentation_u24lambda_u2d11;
        TypeSpec.Builder builder;
        TypeSpec.Builder builder2;
        String typeName = StringsKt.replace$default((String)MTypeNameKt.getKotlin-x-WKhkU((String)io.fluidsonic.meta.MQualifiedTypeNameKt.withoutPackage-tsNLATY((String)codec.getName-NV_oo0w())), (char)'.', (char)'_', (boolean)false, (int)4, null);
        TypeSpec.Builder $this$generateForStructuredRepresentation_u24lambda_u2d9 = builder2 = FileSpec.Companion.builder(MPackageNameKt.getKotlin-GNTwjs4((String)io.fluidsonic.meta.MQualifiedTypeNameKt.getPackageName-tsNLATY((String)codec.getName-NV_oo0w())), typeName).indent("\t");
        boolean bl = false;
        if (codec.getDecodingStrategy() != null) {
            boolean usesReflection;
            String[] $this$any$iv;
            block11: {
                boolean bl2;
                String[] stringArray = new String[]{"missingPropertyError", "readBooleanOrNull", "readByteOrNull", "readCharOrNull", "readDoubleOrNull", "readFloatOrNull", "readFromMapByElementValue", "readIntOrNull", "readLongOrNull", "readShortOrNull", "readStringOrNull", "readValueOfType", "readValueOfTypeOrNull"};
                $this$generateForStructuredRepresentation_u24lambda_u2d9.addImport("io.fluidsonic.json", stringArray);
                $this$any$iv = (String[])codec.getDecodingStrategy().getProperties();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object pair : $this$any$iv) {
                        ProcessingResult.Codec.DecodableProperty it = (ProcessingResult.Codec.DecodableProperty)pair;
                        boolean bl3 = false;
                        if (!(it.getDefaultValue() == ProcessingResult.Codec.DecodableProperty.DefaultValue.defaultArgument)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = usesReflection = false;
                }
            }
            if (usesReflection) {
                $this$any$iv = new String[]{"KClass"};
                $this$generateForStructuredRepresentation_u24lambda_u2d9.addImport("kotlin.reflect", $this$any$iv);
                $this$any$iv = new String[]{"jvmErasure"};
                $this$generateForStructuredRepresentation_u24lambda_u2d9.addImport("io.fluidsonic.json", $this$any$iv);
            }
        }
        if (codec.getEncodingStrategy() != null) {
            Iterable $this$forEach$iv;
            Object usesReflection = new String[]{"writeIntoMap", "writeBooleanOrNull", "writeByteOrNull", "writeCharOrNull", "writeDoubleOrNull", "writeFloatOrNull", "writeIntOrNull", "writeLongOrNull", "writeShortOrNull", "writeStringOrNull", "writeValueOrNull", "writeMapElement"};
            $this$generateForStructuredRepresentation_u24lambda_u2d9.addImport("io.fluidsonic.json", usesReflection);
            usesReflection = codec.getEncodingStrategy().getProperties();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProcessingResult.Codec.EncodableProperty encodableProperty = (ProcessingResult.Codec.EncodableProperty)element$iv;
                boolean bl4 = false;
                if (encodableProperty.getImportPackageName-lnPZ-7c() == null) continue;
                String[] bl3 = new String[]{encodableProperty.getName-qHWkUaA()};
                $this$generateForStructuredRepresentation_u24lambda_u2d9.addImport(MPackageNameKt.getKotlin-GNTwjs4((String)encodableProperty.getImportPackageName-lnPZ-7c()), bl3);
            }
            $this$forEach$iv = codec.getEncodingStrategy().getCustomPropertyMethods();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl5 = false;
                MPackageName mPackageName = (MPackageName)pair.component1();
                String packageName = mPackageName != null ? mPackageName.unbox-impl() : null;
                String name = ((MFunctionName)pair.component2()).unbox-impl();
                if (packageName == null) continue;
                String[] stringArray = new String[]{name};
                $this$generateForStructuredRepresentation_u24lambda_u2d9.addImport(MPackageNameKt.getKotlin-GNTwjs4((String)packageName), stringArray);
            }
        }
        TypeSpec.Builder builder3 = builder2;
        builder2 = TypeSpec.Companion.objectBuilder(typeName);
        boolean condition$iv232 = !codec.isPublic();
        boolean $i$f$applyIf = false;
        if (condition$iv232) {
            void $this$generateForStructuredRepresentation_u24lambda_u2d10;
            void $this$applyIf$iv;
            void $this$forEach$iv = $this$applyIf$iv;
            builder = builder3;
            boolean bl6 = false;
            KModifier[] kModifierArray = new KModifier[]{KModifier.INTERNAL};
            $this$generateForStructuredRepresentation_u24lambda_u2d10.addModifiers(kModifierArray);
            builder3 = builder;
        }
        TypeSpec.Builder builder4 = builder2;
        builder2 = new TypeSpec.Builder[]{codec.getValueType(), (TypeName)MQualifiedTypeNameKt.forKotlinPoet-KwEpx3k$default(codec.getContextType-NV_oo0w(), false, 1, null)};
        TypeSpec.Builder condition$iv232 = builder2 = builder4.superclass((TypeName)ParameterizedTypeName.Companion.get(TypeNames.get((KClass)(codec.getDecodingStrategy() == null ? Reflection.getOrCreateKotlinClass(AbstractJsonEncoderCodec.class) : (codec.getEncodingStrategy() == null ? Reflection.getOrCreateKotlinClass(AbstractJsonDecoderCodec.class) : Reflection.getOrCreateKotlinClass(AbstractJsonCodec.class)))), (TypeName[])builder2));
        builder = builder3;
        boolean bl7 = false;
        if (codec.getDecodingStrategy() != null) {
            this.generateDecode((TypeSpec.Builder)$this$generateForStructuredRepresentation_u24lambda_u2d11, codec, codec.getDecodingStrategy(), codec.getValueType());
        }
        if (codec.getEncodingStrategy() != null) {
            this.generateEncode((TypeSpec.Builder)$this$generateForStructuredRepresentation_u24lambda_u2d11, codec, codec.getEncodingStrategy(), codec.getValueType());
        }
        builder.addType(builder2.build()).build().writeTo(this.outputDirectory);
    }

    private final TypeSpec.Builder generateDecode(TypeSpec.Builder $this$generateDecode, ProcessingResult.Codec codec, ProcessingResult.Codec.DecodingStrategy strategy, TypeName valueType) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = strategy.getProperties();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ProcessingResult.Codec.DecodableProperty it = (ProcessingResult.Codec.DecodableProperty)element$iv;
                    boolean bl2 = false;
                    if (!(it.getDefaultValue() == ProcessingResult.Codec.DecodableProperty.DefaultValue.defaultArgument)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? this.generateDecodeWithReflection($this$generateDecode, codec, strategy, valueType) : this.generateDecodeWithoutReflection($this$generateDecode, codec, strategy, valueType);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec.Builder generateDecodeWithReflection(TypeSpec.Builder $this$generateDecodeWithReflection, ProcessingResult.Codec codec, ProcessingResult.Codec.DecodingStrategy strategy, TypeName valueType) {
        void $this$generateDecodeWithReflection_u24lambda_u2d22;
        Object[] $this$generateDecodeWithReflection_u24lambda_u2d20;
        void $this$generateDecodeWithReflection_u24lambda_u2d18;
        TypeName[] typeNameArray = new TypeName[]{(TypeName)MQualifiedTypeNameKt.forKotlinPoet-KwEpx3k$default(codec.getContextType-NV_oo0w(), false, 1, null)};
        ParameterizedTypeName decoderType = ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(JsonDecoder.class)), typeNameArray);
        Iterable $this$sortedBy$iv = strategy.getProperties();
        boolean $i$f$sortedBy22 = false;
        List properties = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProcessingResult.Codec.DecodableProperty it = (ProcessingResult.Codec.DecodableProperty)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getSerializedName());
                it = (ProcessingResult.Codec.DecodableProperty)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSerializedName())));
            }
        });
        ParameterizedTypeName parameterizedTypeName = valueType instanceof ParameterizedTypeName ? (ParameterizedTypeName)valueType : null;
        TypeName rawValueType = parameterizedTypeName != null && (parameterizedTypeName = parameterizedTypeName.getRawType()) != null ? (TypeName)parameterizedTypeName : valueType;
        Object[] $i$f$sortedBy22 = new TypeName[]{valueType};
        PropertySpec.Builder builder = PropertySpec.Companion.builder("constructor", (TypeName)ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(KFunction.class)), (TypeName[])$i$f$sortedBy22), new KModifier[0]);
        $i$f$sortedBy22 = new KModifier[]{KModifier.PRIVATE};
        PropertySpec.Builder builder2 = builder.addModifiers((KModifier[])$i$f$sortedBy22);
        $i$f$sortedBy22 = new Object[]{rawValueType};
        CodeBlock.Builder builder3 = CodeBlock.Companion.builder().beginControlFlow("%T::class.constructors.single\u00b7{\u00b7constructor\u00b7->", $i$f$sortedBy22);
        $i$f$sortedBy22 = new Object[]{properties.size()};
        CodeBlock.Builder builder4 = builder3.addStatement("if (constructor.parameters.size != %L) return@single\u00b7false\n", $i$f$sortedBy22);
        PropertySpec.Builder builder5 = builder2;
        TypeSpec.Builder builder6 = $this$generateDecodeWithReflection;
        boolean bl = false;
        $this$generateDecodeWithReflection_u24lambda_u2d18.beginControlFlow("constructor.parameters.forEach { parameter ->", new Object[0]);
        $this$generateDecodeWithReflection_u24lambda_u2d18.addStatement("val erasure = parameter.type.jvmErasure\n", new Object[0]);
        void $this$generateDecodeWithReflection_u24lambda_u2d18_u24lambda_u2d17 = $this$generateDecodeWithReflection_u24lambda_u2d18;
        boolean bl2 = false;
        $this$generateDecodeWithReflection_u24lambda_u2d18_u24lambda_u2d17.beginControlFlow("when (parameter.name) {", new Object[0]);
        void $this$generateDecodeWithReflection_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16 = $this$generateDecodeWithReflection_u24lambda_u2d18_u24lambda_u2d17;
        boolean bl3 = false;
        Iterable $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            TypeName rawType;
            Object[] objectArray;
            ProcessingResult.Codec.DecodableProperty property;
            block15: {
                property = (ProcessingResult.Codec.DecodableProperty)element$iv;
                boolean bl4 = false;
                objectArray = property.getType();
                ParameterizedTypeName parameterizedTypeName2 = objectArray instanceof ParameterizedTypeName ? (ParameterizedTypeName)objectArray : null;
                rawType = parameterizedTypeName2 != null && (parameterizedTypeName2 = parameterizedTypeName2.getRawType()) != null ? (TypeName)parameterizedTypeName2 : property.getType();
                List $this$indexOfFirst$iv = strategy.getMeta().getValueParameters();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    MValueParameter it = (MValueParameter)item$iv;
                    boolean bl5 = false;
                    if (MVariableName.equals-impl0((String)it.getName-qHWkUaA(), (String)property.getName-qHWkUaA())) {
                        n = index$iv;
                        break block15;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int index = n;
            objectArray = new Object[]{MVariableName.box-impl((String)property.getName-qHWkUaA()), index, TypeName.copy$default((TypeName)rawType, (boolean)false, null, (int)2, null)};
            $this$generateDecodeWithReflection_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16.addStatement("%1S -> if (parameter.index != %2L || parameter.isVararg || erasure != %3T::class) return@single\u00b7false", objectArray);
        }
        $this$generateDecodeWithReflection_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16.addStatement("else -> return@single\u00b7false", new Object[0]);
        $this$generateDecodeWithReflection_u24lambda_u2d18_u24lambda_u2d17.endControlFlow();
        $this$generateDecodeWithReflection_u24lambda_u2d18.endControlFlow();
        $this$generateDecodeWithReflection_u24lambda_u2d18.add("\n", new Object[0]);
        CodeBlock.Builder builder7 = $this$generateDecodeWithReflection_u24lambda_u2d18.addStatement("return@single\u00b7true", new Object[0]);
        builder6.addProperty(builder5.initializer(builder7.endControlFlow().build()).build());
        Iterable $this$forEach$iv2 = properties;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            ProcessingResult.Codec.DecodableProperty property = (ProcessingResult.Codec.DecodableProperty)element$iv;
            boolean bl6 = false;
            Object[] objectArray = new KModifier[]{KModifier.PRIVATE};
            PropertySpec.Builder builder8 = PropertySpec.Companion.builder("parameter_" + MVariableName.toString-impl((String)property.getName-qHWkUaA()), Reflection.getOrCreateKotlinClass(KParameter.class), new KModifier[0]).addModifiers((KModifier[])objectArray);
            objectArray = new Object[]{MVariableName.box-impl((String)property.getName-qHWkUaA())};
            $this$generateDecodeWithReflection.addProperty(builder8.initializer("constructor.parameters.first { it.name == %S }", objectArray).build());
        }
        Object[] objectArray = new KModifier[]{KModifier.OVERRIDE};
        FunSpec.Builder builder9 = FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder("decode").addModifiers((KModifier[])objectArray), (TypeName)((TypeName)decoderType), null, (int)2, null);
        objectArray = new TypeName[]{valueType};
        FunSpec.Builder builder10 = FunSpec.Builder.returns$default((FunSpec.Builder)builder9.addParameter("valueType", (TypeName)ParameterizedTypeName.Companion.get(codingType, (TypeName[])objectArray), new KModifier[0]), (TypeName)valueType, null, (int)2, null).addCode("val arguments = hashMapOf<KParameter, Any?>()\n", new Object[0]);
        objectArray = new Object[]{"key"};
        FunSpec.Builder builder11 = builder10.addCode("readFromMapByElementValue { %N ->\n\u21e5", objectArray);
        objectArray = new Object[]{"key"};
        Object[] $i$f$forEach22 = objectArray = builder11.beginControlFlow("when (%N)", objectArray);
        builder6 = $this$generateDecodeWithReflection;
        boolean bl7 = false;
        for (ProcessingResult.Codec.DecodableProperty property : properties) {
            String functionName = this.methodNameForReadingValueOfType(property.getType());
            if (property.getTypeParameterIndex() >= 0) {
                if (Intrinsics.areEqual((Object)property.getType(), (Object)KotlinpoetTypeNames.INSTANCE.getAny()) || Intrinsics.areEqual((Object)property.getType(), (Object)KotlinpoetTypeNames.INSTANCE.getNullableAny())) {
                    Object[] objectArray2 = new Object[]{property.getSerializedName(), "parameter_" + MVariableName.toString-impl((String)property.getName-qHWkUaA()), functionName, property.getTypeParameterIndex()};
                    $this$generateDecodeWithReflection_u24lambda_u2d20.addStatement("%1S -> arguments[%2N] = %3N(valueType.arguments[%4L])", objectArray2);
                    continue;
                }
                Object[] objectArray3 = new Object[]{property.getSerializedName(), "parameter_" + MVariableName.toString-impl((String)property.getName-qHWkUaA()), functionName, property.getTypeParameterIndex(), property.getType()};
                $this$generateDecodeWithReflection_u24lambda_u2d20.addStatement("%1S -> arguments[%2N] = %3N(valueType.arguments[%4L]) as %5T", objectArray3);
                continue;
            }
            if (StringsKt.startsWith$default((String)functionName, (String)"readValueOfType", (boolean)false, (int)2, null)) {
                Object[] objectArray4 = new Object[]{property.getSerializedName(), "parameter_" + MVariableName.toString-impl((String)property.getName-qHWkUaA()), functionName, TypeName.copy$default((TypeName)property.getType(), (boolean)false, null, (int)2, null)};
                $this$generateDecodeWithReflection_u24lambda_u2d20.addStatement("%1S -> arguments[%2N] = %3N<%4T>()", objectArray4);
                continue;
            }
            Object[] objectArray5 = new Object[]{property.getSerializedName(), "parameter_" + MVariableName.toString-impl((String)property.getName-qHWkUaA()), functionName};
            $this$generateDecodeWithReflection_u24lambda_u2d20.addStatement("%1S -> arguments[%2N] = %3N()", objectArray5);
        }
        $this$generateDecodeWithReflection_u24lambda_u2d20.addStatement("else -> skipValue()", new Object[0]);
        $this$generateDecodeWithReflection_u24lambda_u2d20 = objectArray = objectArray.endControlFlow().addCode("\u21e4}\n", new Object[0]).addCode("\n", new Object[0]);
        boolean bl8 = false;
        boolean hasChecks = false;
        Iterable $this$forEach$iv3 = properties;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            ProcessingResult.Codec.DecodableProperty property = (ProcessingResult.Codec.DecodableProperty)element$iv;
            boolean bl9 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[property.getDefaultValue().ordinal()]) {
                case 1: {
                    Object[] objectArray6 = new Object[]{"parameter_" + MVariableName.toString-impl((String)property.getName-qHWkUaA())};
                    $this$generateDecodeWithReflection_u24lambda_u2d22.addStatement("if (!arguments.containsKey(%1N)) arguments[%1N] = null", objectArray6);
                    hasChecks = true;
                    break;
                }
                case 2: {
                    Object[] objectArray6 = new Object[]{"parameter_" + MVariableName.toString-impl((String)property.getName-qHWkUaA()), property.getSerializedName()};
                    $this$generateDecodeWithReflection_u24lambda_u2d22.addStatement("if (!arguments.containsKey(%1N)) missingPropertyError(%2S)", objectArray6);
                    hasChecks = true;
                    break;
                }
                case 3: {
                }
            }
        }
        if (hasChecks) {
            $this$generateDecodeWithReflection_u24lambda_u2d22.addCode("\n", new Object[0]);
        }
        $this$generateDecodeWithReflection_u24lambda_u2d22.addStatement("return constructor.callBy(arguments)", new Object[0]);
        return builder6.addFunction(objectArray.build());
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec.Builder generateDecodeWithoutReflection(TypeSpec.Builder $this$generateDecodeWithoutReflection, ProcessingResult.Codec codec, ProcessingResult.Codec.DecodingStrategy strategy, TypeName valueType) {
        ParameterizedTypeName parameterizedTypeName;
        void $this$generateDecodeWithoutReflection_u24lambda_u2d30;
        Iterator iterator;
        ProcessingResult.Codec.DecodableProperty it;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        TypeName[] $this$generateDecodeWithoutReflection_u24lambda_u2d25;
        String functionName;
        TypeName[] $this$generateDecodeWithoutReflection_u24lambda_u2d24;
        Object[] propertyType;
        TypeName[] typeNameArray = new TypeName[]{(TypeName)MQualifiedTypeNameKt.forKotlinPoet-KwEpx3k$default(codec.getContextType-NV_oo0w(), false, 1, null)};
        ParameterizedTypeName decoderType = ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(JsonDecoder.class)), typeNameArray);
        Iterable $this$sortedBy$iv = strategy.getProperties();
        boolean $i$f$sortedBy22 = false;
        List properties = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProcessingResult.Codec.DecodableProperty it = (ProcessingResult.Codec.DecodableProperty)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getSerializedName());
                it = (ProcessingResult.Codec.DecodableProperty)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSerializedName())));
            }
        });
        Object[] objectArray = new FunSpec.Builder[]{KModifier.OVERRIDE};
        FunSpec.Builder builder = FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder("decode").addModifiers((KModifier[])objectArray), (TypeName)((TypeName)decoderType), null, (int)2, null);
        objectArray = new TypeName[]{valueType};
        TypeName[] $i$f$sortedBy22 = objectArray = FunSpec.Builder.returns$default((FunSpec.Builder)builder.addParameter("valueType", (TypeName)ParameterizedTypeName.Companion.get(codingType, objectArray), new KModifier[0]), (TypeName)valueType, null, (int)2, null);
        TypeSpec.Builder builder2 = $this$generateDecodeWithoutReflection;
        boolean bl = false;
        for (ProcessingResult.Codec.DecodableProperty property : properties) {
            Object[] objectArray2;
            String localVariableName = '_' + MVariableName.toString-impl((String)property.getName-qHWkUaA());
            propertyType = property.getType();
            if (Intrinsics.areEqual((Object)propertyType, (Object)KotlinpoetTypeNames.INSTANCE.getBoolean())) {
                objectArray2 = new Object[]{localVariableName};
                $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %N = false", objectArray2);
            } else if (Intrinsics.areEqual((Object)propertyType, (Object)KotlinpoetTypeNames.INSTANCE.getByte())) {
                objectArray2 = new Object[]{localVariableName};
                $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %N = 0.toByte()", objectArray2);
            } else if (Intrinsics.areEqual((Object)propertyType, (Object)KotlinpoetTypeNames.INSTANCE.getChar())) {
                objectArray2 = new Object[]{localVariableName};
                $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %N = 0.toChar()", objectArray2);
            } else if (Intrinsics.areEqual((Object)propertyType, (Object)KotlinpoetTypeNames.INSTANCE.getDouble())) {
                objectArray2 = new Object[]{localVariableName};
                $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %N = 0.0", objectArray2);
            } else if (Intrinsics.areEqual((Object)propertyType, (Object)KotlinpoetTypeNames.INSTANCE.getFloat())) {
                objectArray2 = new Object[]{localVariableName};
                $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %N = 0.0f", objectArray2);
            } else if (Intrinsics.areEqual((Object)propertyType, (Object)KotlinpoetTypeNames.INSTANCE.getInt())) {
                objectArray2 = new Object[]{localVariableName};
                $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %N = 0", objectArray2);
            } else if (Intrinsics.areEqual((Object)propertyType, (Object)KotlinpoetTypeNames.INSTANCE.getLong())) {
                objectArray2 = new Object[]{localVariableName};
                $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %N = 0L", objectArray2);
            } else if (Intrinsics.areEqual((Object)propertyType, (Object)KotlinpoetTypeNames.INSTANCE.getShort())) {
                objectArray2 = new Object[]{localVariableName};
                $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %N = 0.toShort()", objectArray2);
            } else if (propertyType.isNullable()) {
                objectArray2 = new Object[]{localVariableName, propertyType};
                $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %1N: %2T = null", objectArray2);
            } else {
                objectArray2 = new Object[]{localVariableName, propertyType};
                $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %1N: %2T? = null", objectArray2);
            }
            if (!KotlinpoetTypeNamesKt.isPrimitive(property.getType())) continue;
            objectArray2 = new Object[]{MVariableName.toString-impl((String)property.getName-qHWkUaA()) + "_isPresent"};
            $this$generateDecodeWithoutReflection_u24lambda_u2d24.addStatement("var %1N = false", objectArray2);
        }
        FunSpec.Builder builder3 = objectArray.addCode("\n", new Object[0]);
        objectArray = new Object[]{"key"};
        FunSpec.Builder builder4 = builder3.addCode("readFromMapByElementValue { %N ->\n\u21e5", objectArray);
        objectArray = new Object[]{"key"};
        $this$generateDecodeWithoutReflection_u24lambda_u2d24 = objectArray = builder4.beginControlFlow("when (%N)", objectArray);
        boolean bl2 = false;
        for (ProcessingResult.Codec.DecodableProperty property : properties) {
            functionName = this.methodNameForReadingValueOfType(property.getType());
            if (KotlinpoetTypeNamesKt.isPrimitive(property.getType())) {
                propertyType = new Object[]{property.getSerializedName()};
                $this$generateDecodeWithoutReflection_u24lambda_u2d25.beginControlFlow("%S -> ", propertyType);
                propertyType = new Object[]{'_' + MVariableName.toString-impl((String)property.getName-qHWkUaA()), functionName};
                $this$generateDecodeWithoutReflection_u24lambda_u2d25.addStatement("%1N = %2N()", propertyType);
                propertyType = new Object[]{MVariableName.toString-impl((String)property.getName-qHWkUaA()) + "_isPresent"};
                $this$generateDecodeWithoutReflection_u24lambda_u2d25.addStatement("%N = true", propertyType);
                $this$generateDecodeWithoutReflection_u24lambda_u2d25.endControlFlow();
                continue;
            }
            if (property.getTypeParameterIndex() >= 0) {
                if (Intrinsics.areEqual((Object)property.getType(), (Object)KotlinpoetTypeNames.INSTANCE.getAny()) || Intrinsics.areEqual((Object)property.getType(), (Object)KotlinpoetTypeNames.INSTANCE.getNullableAny())) {
                    propertyType = new Object[]{property.getSerializedName(), '_' + MVariableName.toString-impl((String)property.getName-qHWkUaA()), functionName, property.getTypeParameterIndex()};
                    $this$generateDecodeWithoutReflection_u24lambda_u2d25.addStatement("%1S -> %2N = %3N(valueType.arguments[%4L])", propertyType);
                    continue;
                }
                propertyType = new Object[]{property.getSerializedName(), '_' + MVariableName.toString-impl((String)property.getName-qHWkUaA()), functionName, property.getTypeParameterIndex(), property.getType()};
                $this$generateDecodeWithoutReflection_u24lambda_u2d25.addStatement("%1S -> %2N = %3N(valueType.arguments[%4L]) as %5T", propertyType);
                continue;
            }
            propertyType = new Object[]{property.getSerializedName(), '_' + MVariableName.toString-impl((String)property.getName-qHWkUaA()), functionName};
            $this$generateDecodeWithoutReflection_u24lambda_u2d25.addStatement("%1S -> %2N = %3N()", propertyType);
        }
        $this$generateDecodeWithoutReflection_u24lambda_u2d25.addStatement("else -> skipValue()", new Object[0]);
        $this$generateDecodeWithoutReflection_u24lambda_u2d25 = objectArray = objectArray.endControlFlow().addCode("\u21e4}\n", new Object[0]).addCode("\n", new Object[0]);
        boolean bl3 = false;
        Object object = properties;
        boolean $i$f$filter = false;
        functionName = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProcessingResult.Codec.DecodableProperty)element$iv$iv;
            boolean bl4 = false;
            if (!KotlinpoetTypeNamesKt.isPrimitive(it.getType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        if (object.isEmpty()) {
            boolean bl5 = false;
            iterator = null;
        } else {
            iterator = object;
        }
        Object[] objectArray3 = (Object[])iterator;
        if (objectArray3 != null) {
            Iterator $this$generateDecodeWithoutReflection_u24lambda_u2d30_u24lambda_u2d29 = object = objectArray3;
            boolean bl6 = false;
            Iterable $this$forEach$iv = (Iterable)((Object)$this$generateDecodeWithoutReflection_u24lambda_u2d30_u24lambda_u2d29);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ProcessingResult.Codec.DecodableProperty)element$iv;
                boolean bl7 = false;
                Object[] objectArray4 = new Object[]{MVariableName.toString-impl((String)it.getName-qHWkUaA()) + "_isPresent", it.getSerializedName()};
                $this$generateDecodeWithoutReflection_u24lambda_u2d30.addStatement("%N || missingPropertyError(%S)", objectArray4);
            }
            $this$generateDecodeWithoutReflection_u24lambda_u2d30.addCode("\n", new Object[0]);
        }
        objectArray3 = new Object[]{(parameterizedTypeName = valueType instanceof ParameterizedTypeName ? (ParameterizedTypeName)valueType : null) != null && (parameterizedTypeName = parameterizedTypeName.getRawType()) != null ? (TypeName)parameterizedTypeName : valueType};
        $this$generateDecodeWithoutReflection_u24lambda_u2d30.addCode("return %T(\n\u21e5", objectArray3);
        int size = properties.size();
        object = properties.iterator();
        int n = 0;
        while (object.hasNext()) {
            Object[] objectArray5;
            int index = n++;
            ProcessingResult.Codec.DecodableProperty property = (ProcessingResult.Codec.DecodableProperty)object.next();
            TypeName propertyType2 = property.getType();
            if (propertyType2.isNullable() || KotlinpoetTypeNamesKt.isPrimitive(propertyType2)) {
                objectArray5 = new Object[]{MVariableName.toString-impl((String)property.getName-qHWkUaA()), '_' + MVariableName.toString-impl((String)property.getName-qHWkUaA())};
                $this$generateDecodeWithoutReflection_u24lambda_u2d30.addCode("%1N = %2N", objectArray5);
            } else {
                objectArray5 = new Object[]{MVariableName.toString-impl((String)property.getName-qHWkUaA()), '_' + MVariableName.toString-impl((String)property.getName-qHWkUaA()), property.getSerializedName()};
                $this$generateDecodeWithoutReflection_u24lambda_u2d30.addCode("%1N = %2N ?: missingPropertyError(%3S)", objectArray5);
            }
            if (index < size - 1) {
                $this$generateDecodeWithoutReflection_u24lambda_u2d30.addCode(",", new Object[0]);
            }
            $this$generateDecodeWithoutReflection_u24lambda_u2d30.addCode("\n", new Object[0]);
        }
        $this$generateDecodeWithoutReflection_u24lambda_u2d30.addCode("\u21e4)\n", new Object[0]);
        return builder2.addFunction(objectArray.build());
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec.Builder generateEncode(TypeSpec.Builder $this$generateEncode, ProcessingResult.Codec codec, ProcessingResult.Codec.EncodingStrategy strategy, TypeName valueType) {
        void $this$generateEncode_u24lambda_u2d33;
        TypeName[] typeNameArray = new TypeName[]{(TypeName)MQualifiedTypeNameKt.forKotlinPoet-KwEpx3k$default(codec.getContextType-NV_oo0w(), false, 1, null)};
        ParameterizedTypeName encoderType = ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(JsonEncoder.class)), typeNameArray);
        Iterable $this$sortedBy$iv = strategy.getCustomPropertyMethods();
        boolean $i$f$sortedBy = false;
        List customPropertyMethod = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((MFunctionName)it.getSecond()).unbox-impl());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((MFunctionName)it.getSecond()).unbox-impl())));
            }
        });
        Iterable $this$sortedBy$iv2 = strategy.getProperties();
        boolean $i$f$sortedBy22 = false;
        List properties = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProcessingResult.Codec.EncodableProperty it = (ProcessingResult.Codec.EncodableProperty)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getSerializedName());
                it = (ProcessingResult.Codec.EncodableProperty)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSerializedName())));
            }
        });
        FunSpec.Builder builder = new FunSpec.Builder[]{KModifier.OVERRIDE};
        FunSpec.Builder $i$f$sortedBy22 = builder = FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder("encode").addModifiers((KModifier[])builder), (TypeName)((TypeName)encoderType), null, (int)2, null).addParameter("value", valueType, new KModifier[0]).beginControlFlow("writeIntoMap", new Object[0]);
        TypeSpec.Builder builder2 = $this$generateEncode;
        boolean bl = false;
        for (ProcessingResult.Codec.EncodableProperty property : properties) {
            Object[] objectArray = new Object[]{property.getSerializedName(), this.parameterNameForWritingValueOfType(property.getType()), MVariableName.toString-impl((String)property.getName-qHWkUaA())};
            $this$generateEncode_u24lambda_u2d33.addStatement("writeMapElement(%1S, %2N = value.%3N)", objectArray);
        }
        for (Pair pair : customPropertyMethod) {
            Object[] objectArray;
            MPackageName mPackageName = (MPackageName)pair.component1();
            String packageName = mPackageName != null ? mPackageName.unbox-impl() : null;
            String functionName = ((MFunctionName)pair.component2()).unbox-impl();
            if (packageName != null) {
                objectArray = new Object[]{MFunctionName.toString-impl((String)functionName)};
                $this$generateEncode_u24lambda_u2d33.addStatement("%N(value)", objectArray);
                continue;
            }
            objectArray = new Object[]{MFunctionName.toString-impl((String)functionName)};
            $this$generateEncode_u24lambda_u2d33.addStatement("value.run { this@encode.%N() }", objectArray);
        }
        return builder2.addFunction(builder.endControlFlow().build());
    }

    /*
     * WARNING - void declaration
     */
    private final String methodNameForReadingValueOfType(TypeName type) {
        void var3_3;
        TypeName typeName = type;
        String it = Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getBoolean()) ? "readBoolean" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getByte()) ? "readByte" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getChar()) ? "readChar" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getDouble()) ? "readDouble" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getFloat()) ? "readFloat" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getInt()) ? "readInt" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getLong()) ? "readLong" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getShort()) ? "readShort" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getString()) ? "readString" : "readValueOfType"))))))));
        boolean bl = false;
        return type.isNullable() ? it + "OrNull" : var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final String methodNameForWritingValueOfType(TypeName type) {
        void var3_3;
        TypeName typeName = type;
        String it = Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getBoolean()) ? "writeBoolean" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getByte()) ? "writeByte" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getChar()) ? "writeChar" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getDouble()) ? "writeDouble" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getFloat()) ? "writeFloat" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getInt()) ? "writeInt" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getLong()) ? "writeLong" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getShort()) ? "writeShort" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getString()) ? "writeString" : "writeValue"))))))));
        boolean bl = false;
        return type.isNullable() ? it + "OrNull" : var3_3;
    }

    private final String parameterNameForWritingValueOfType(TypeName type) {
        TypeName typeName = type;
        return Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getBoolean()) ? "boolean" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getByte()) ? "byte" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getChar()) ? "char" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getDouble()) ? "double" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getFloat()) ? "float" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getInt()) ? "int" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getLong()) ? "long" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getShort()) ? "short" : (Intrinsics.areEqual((Object)typeName, (Object)KotlinpoetTypeNames.INSTANCE.getString()) ? "string" : "value"))))))));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/fluidsonic/json/annotationprocessor/CodecGenerator$Companion;", "", "()V", "codingType", "Lcom/squareup/kotlinpoet/ClassName;", "fluid-json-annotation-processor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProcessingResult.Codec.DecodableProperty.DefaultValue.values().length];
            nArray[ProcessingResult.Codec.DecodableProperty.DefaultValue.nullReference.ordinal()] = 1;
            nArray[ProcessingResult.Codec.DecodableProperty.DefaultValue.none.ordinal()] = 2;
            nArray[ProcessingResult.Codec.DecodableProperty.DefaultValue.defaultArgument.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

