/*
 * Decompiled with CFR 0.152.
 */
package io.fluidsonic.graphql;

import io.fluidsonic.graphql.GFragmentDefinition;
import io.fluidsonic.graphql.GInlineFragmentSelection;
import io.fluidsonic.graphql.GNamedTypeRef;
import io.fluidsonic.graphql.ValidationContext;
import io.fluidsonic.graphql.ValidationRule;
import io.fluidsonic.graphql.Visit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000e"}, d2={"Lio/fluidsonic/graphql/FragmentTypeConditionExistenceRule;", "Lio/fluidsonic/graphql/ValidationRule$Singleton;", "()V", "onFragmentDefinition", "", "definition", "Lio/fluidsonic/graphql/GFragmentDefinition;", "data", "Lio/fluidsonic/graphql/ValidationContext;", "visit", "Lio/fluidsonic/graphql/Visit;", "onInlineFragmentSelection", "selection", "Lio/fluidsonic/graphql/GInlineFragmentSelection;", "fluid-graphql-execution"})
public final class FragmentTypeConditionExistenceRule
extends ValidationRule.Singleton {
    @NotNull
    public static final FragmentTypeConditionExistenceRule INSTANCE = new FragmentTypeConditionExistenceRule();

    private FragmentTypeConditionExistenceRule() {
    }

    protected void onFragmentDefinition(@NotNull GFragmentDefinition definition, @NotNull ValidationContext data, @NotNull Visit visit) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        Intrinsics.checkNotNullParameter((Object)visit, (String)"visit");
        if (data.getSchema().resolveType(definition.getTypeCondition()) != null) {
            return;
        }
        data.reportError("A fragment must be specified on a type that exist in the schema.", CollectionsKt.listOf((Object)definition.getTypeCondition()));
    }

    protected void onInlineFragmentSelection(@NotNull GInlineFragmentSelection selection, @NotNull ValidationContext data, @NotNull Visit visit) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        Intrinsics.checkNotNullParameter((Object)visit, (String)"visit");
        GNamedTypeRef gNamedTypeRef = selection.getTypeCondition();
        if (gNamedTypeRef == null) {
            return;
        }
        GNamedTypeRef typeCondition = gNamedTypeRef;
        if (data.getSchema().resolveType(typeCondition) != null) {
            return;
        }
        data.reportError("A fragment spread must be specified on a type that exist in the schema.", CollectionsKt.listOf((Object)typeCondition));
    }
}

