/*
 * Decompiled with CFR 0.152.
 */
package io.fluidsonic.currency;

import io.fluidsonic.currency.CharKt;
import io.fluidsonic.currency.Currency;
import io.fluidsonic.currency.CurrencyCodeSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=CurrencyCodeSerializer.class)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0006\u0010\n\u001a\u00020\u0006J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/fluidsonic/currency/CurrencyCode;", "", "value", "", "(Ljava/lang/String;)V", "equals", "", "other", "hashCode", "", "isValid", "toString", "Companion", "fluid-currency"})
public final class CurrencyCode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;

    public CurrencyCode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        CurrencyCode $this$freeze$iv = this;
        boolean $i$f$freeze = false;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof CurrencyCode && Intrinsics.areEqual((Object)this.value, (Object)((CurrencyCode)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public final boolean isValid() {
        return Currency.Companion.forCodeOrNull(this) != null;
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u00c6\u0001\u00a8\u0006\f"}, d2={"Lio/fluidsonic/currency/CurrencyCode$Companion;", "", "()V", "isValidFormat", "", "string", "", "parse", "Lio/fluidsonic/currency/CurrencyCode;", "parseOrNull", "serializer", "Lkotlinx/serialization/KSerializer;", "fluid-currency"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CurrencyCode parse(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            CurrencyCode currencyCode = this.parseOrNull(string);
            if (currencyCode == null) {
                String string2 = Intrinsics.stringPlus((String)"Invalid ISO 4217 currency code format: ", (Object)string);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return currencyCode;
        }

        @Nullable
        public final CurrencyCode parseOrNull(@NotNull String string) {
            CurrencyCode currencyCode;
            String string2;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            String string3 = string;
            boolean bl = false;
            boolean bl2 = false;
            String p0 = string3;
            boolean bl3 = false;
            String string4 = string2 = this.isValidFormat(p0) ? string3 : null;
            if (string2 == null) {
                currencyCode = null;
            } else {
                string3 = string2;
                bl = false;
                bl2 = false;
                String it = string3;
                boolean bl4 = false;
                String string5 = it;
                boolean bl5 = false;
                String string6 = string5.toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
                currencyCode = new CurrencyCode(string6);
            }
            return currencyCode;
        }

        private final boolean isValidFormat(String string) {
            return string.length() == 3 && CharKt.isLatinLetter(string.charAt(0)) && CharKt.isLatinLetter(string.charAt(1)) && CharKt.isLatinLetter(string.charAt(2));
        }

        @NotNull
        public final KSerializer<CurrencyCode> serializer() {
            return CurrencyCodeSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

