/*
 * Decompiled with CFR 0.152.
 */
package io.fluidsonic.currency;

import io.fluidsonic.currency.CurrencyCode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lio/fluidsonic/currency/Currency;", "", "code", "Lio/fluidsonic/currency/CurrencyCode;", "defaultFractionDigits", "", "numericCode", "(Lio/fluidsonic/currency/CurrencyCode;II)V", "getCode", "()Lio/fluidsonic/currency/CurrencyCode;", "getDefaultFractionDigits", "()I", "getNumericCode", "toString", "", "Companion", "fluid-currency"})
public final class Currency {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final CurrencyCode code;
    private final int defaultFractionDigits;
    private final int numericCode;
    @NotNull
    private static final Set<Currency> all;
    @NotNull
    private static final Map<CurrencyCode, Currency> allByCode;

    private Currency(CurrencyCode code, int defaultFractionDigits, int numericCode) {
        this.code = code;
        this.defaultFractionDigits = defaultFractionDigits;
        this.numericCode = numericCode;
        Currency $this$freeze$iv = this;
        boolean $i$f$freeze = false;
    }

    @NotNull
    public final CurrencyCode getCode() {
        return this.code;
    }

    public final int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public final int getNumericCode() {
        return this.numericCode;
    }

    @NotNull
    public String toString() {
        return this.code.toString();
    }

    public /* synthetic */ Currency(CurrencyCode code, int defaultFractionDigits, int numericCode, DefaultConstructorMarker $constructor_marker) {
        this(code, defaultFractionDigits, numericCode);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_2;
        void $this$associateByTo$iv;
        Companion = new Companion(null);
        Object object = new Currency[]{Currency.Companion.make("AED", 2, 784), Currency.Companion.make("AFN", 2, 971), Currency.Companion.make("ALL", 2, 8), Currency.Companion.make("AMD", 2, 51), Currency.Companion.make("ANG", 2, 532), Currency.Companion.make("AOA", 2, 973), Currency.Companion.make("ARS", 2, 32), Currency.Companion.make("AUD", 2, 36), Currency.Companion.make("AWG", 2, 533), Currency.Companion.make("AZN", 2, 944), Currency.Companion.make("BAM", 2, 977), Currency.Companion.make("BBD", 2, 52), Currency.Companion.make("BDT", 2, 50), Currency.Companion.make("BGN", 2, 975), Currency.Companion.make("BHD", 3, 48), Currency.Companion.make("BIF", 0, 108), Currency.Companion.make("BMD", 2, 60), Currency.Companion.make("BND", 2, 96), Currency.Companion.make("BOB", 2, 68), Currency.Companion.make("BOV", 2, 984), Currency.Companion.make("BRL", 2, 986), Currency.Companion.make("BSD", 2, 44), Currency.Companion.make("BTN", 2, 64), Currency.Companion.make("BWP", 2, 72), Currency.Companion.make("BYN", 2, 933), Currency.Companion.make("BZD", 2, 84), Currency.Companion.make("CAD", 2, 124), Currency.Companion.make("CDF", 2, 976), Currency.Companion.make("CHE", 2, 947), Currency.Companion.make("CHF", 2, 756), Currency.Companion.make("CHW", 2, 948), Currency.Companion.make("CLF", 4, 990), Currency.Companion.make("CLP", 0, 152), Currency.Companion.make("CNY", 2, 156), Currency.Companion.make("COP", 2, 170), Currency.Companion.make("COU", 2, 970), Currency.Companion.make("CRC", 2, 188), Currency.Companion.make("CUC", 2, 931), Currency.Companion.make("CUP", 2, 192), Currency.Companion.make("CVE", 2, 132), Currency.Companion.make("CZK", 2, 203), Currency.Companion.make("DJF", 0, 262), Currency.Companion.make("DKK", 2, 208), Currency.Companion.make("DOP", 2, 214), Currency.Companion.make("DZD", 2, 12), Currency.Companion.make("EGP", 2, 818), Currency.Companion.make("ERN", 2, 232), Currency.Companion.make("ETB", 2, 230), Currency.Companion.make("EUR", 2, 978), Currency.Companion.make("FJD", 2, 242), Currency.Companion.make("FKP", 2, 238), Currency.Companion.make("GBP", 2, 826), Currency.Companion.make("GEL", 2, 981), Currency.Companion.make("GHS", 2, 936), Currency.Companion.make("GIP", 2, 292), Currency.Companion.make("GMD", 2, 270), Currency.Companion.make("GNF", 0, 324), Currency.Companion.make("GTQ", 2, 320), Currency.Companion.make("GYD", 2, 328), Currency.Companion.make("HKD", 2, 344), Currency.Companion.make("HNL", 2, 340), Currency.Companion.make("HRK", 2, 191), Currency.Companion.make("HTG", 2, 332), Currency.Companion.make("HUF", 2, 348), Currency.Companion.make("IDR", 2, 360), Currency.Companion.make("ILS", 2, 376), Currency.Companion.make("INR", 2, 356), Currency.Companion.make("IQD", 3, 368), Currency.Companion.make("IRR", 2, 364), Currency.Companion.make("ISK", 0, 352), Currency.Companion.make("JMD", 2, 388), Currency.Companion.make("JOD", 3, 400), Currency.Companion.make("JPY", 0, 392), Currency.Companion.make("KES", 2, 404), Currency.Companion.make("KGS", 2, 417), Currency.Companion.make("KHR", 2, 116), Currency.Companion.make("KMF", 0, 174), Currency.Companion.make("KPW", 2, 408), Currency.Companion.make("KRW", 0, 410), Currency.Companion.make("KWD", 3, 414), Currency.Companion.make("KYD", 2, 136), Currency.Companion.make("KZT", 2, 398), Currency.Companion.make("LAK", 2, 418), Currency.Companion.make("LBP", 2, 422), Currency.Companion.make("LKR", 2, 144), Currency.Companion.make("LRD", 2, 430), Currency.Companion.make("LSL", 2, 426), Currency.Companion.make("LYD", 3, 434), Currency.Companion.make("MAD", 2, 504), Currency.Companion.make("MDL", 2, 498), Currency.Companion.make("MGA", 2, 969), Currency.Companion.make("MKD", 2, 807), Currency.Companion.make("MMK", 2, 104), Currency.Companion.make("MNT", 2, 496), Currency.Companion.make("MOP", 2, 446), Currency.Companion.make("MRU", 2, 929), Currency.Companion.make("MUR", 2, 480), Currency.Companion.make("MVR", 2, 462), Currency.Companion.make("MWK", 2, 454), Currency.Companion.make("MXN", 2, 484), Currency.Companion.make("MXV", 2, 979), Currency.Companion.make("MYR", 2, 458), Currency.Companion.make("MZN", 2, 943), Currency.Companion.make("NAD", 2, 516), Currency.Companion.make("NGN", 2, 566), Currency.Companion.make("NIO", 2, 558), Currency.Companion.make("NOK", 2, 578), Currency.Companion.make("NPR", 2, 524), Currency.Companion.make("NZD", 2, 554), Currency.Companion.make("OMR", 3, 512), Currency.Companion.make("PAB", 2, 590), Currency.Companion.make("PEN", 2, 604), Currency.Companion.make("PGK", 2, 598), Currency.Companion.make("PHP", 2, 608), Currency.Companion.make("PKR", 2, 586), Currency.Companion.make("PLN", 2, 985), Currency.Companion.make("PYG", 0, 600), Currency.Companion.make("QAR", 2, 634), Currency.Companion.make("RON", 2, 946), Currency.Companion.make("RSD", 2, 941), Currency.Companion.make("RUB", 2, 643), Currency.Companion.make("RWF", 0, 646), Currency.Companion.make("SAR", 2, 682), Currency.Companion.make("SBD", 2, 90), Currency.Companion.make("SCR", 2, 690), Currency.Companion.make("SDG", 2, 938), Currency.Companion.make("SEK", 2, 752), Currency.Companion.make("SGD", 2, 702), Currency.Companion.make("SHP", 2, 654), Currency.Companion.make("SLL", 2, 694), Currency.Companion.make("SOS", 2, 706), Currency.Companion.make("SRD", 2, 968), Currency.Companion.make("SSP", 2, 728), Currency.Companion.make("STN", 2, 930), Currency.Companion.make("SVC", 2, 222), Currency.Companion.make("SYP", 2, 760), Currency.Companion.make("SZL", 2, 748), Currency.Companion.make("THB", 2, 764), Currency.Companion.make("TJS", 2, 972), Currency.Companion.make("TMT", 2, 934), Currency.Companion.make("TND", 3, 788), Currency.Companion.make("TOP", 2, 776), Currency.Companion.make("TRY", 2, 949), Currency.Companion.make("TTD", 2, 780), Currency.Companion.make("TWD", 2, 901), Currency.Companion.make("TZS", 2, 834), Currency.Companion.make("UAH", 2, 980), Currency.Companion.make("UGX", 0, 800), Currency.Companion.make("USD", 2, 840), Currency.Companion.make("USN", 2, 997), Currency.Companion.make("UYI", 0, 940), Currency.Companion.make("UYU", 2, 858), Currency.Companion.make("UYW", 4, 927), Currency.Companion.make("UZS", 2, 860), Currency.Companion.make("VES", 2, 928), Currency.Companion.make("VND", 0, 704), Currency.Companion.make("VUV", 0, 548), Currency.Companion.make("WST", 2, 882), Currency.Companion.make("XAF", 0, 950), Currency.Companion.make("XAG", -1, 961), Currency.Companion.make("XAU", -1, 959), Currency.Companion.make("XBA", -1, 955), Currency.Companion.make("XBB", -1, 956), Currency.Companion.make("XBC", -1, 957), Currency.Companion.make("XBD", -1, 958), Currency.Companion.make("XCD", 2, 951), Currency.Companion.make("XDR", -1, 960), Currency.Companion.make("XOF", 0, 952), Currency.Companion.make("XPD", -1, 964), Currency.Companion.make("XPF", 0, 953), Currency.Companion.make("XPT", -1, 962), Currency.Companion.make("XSU", -1, 994), Currency.Companion.make("XTS", -1, 963), Currency.Companion.make("XUA", -1, 965), Currency.Companion.make("XXX", -1, 999), Currency.Companion.make("YER", 2, 886), Currency.Companion.make("ZAR", 2, 710), Currency.Companion.make("ZMW", 2, 967), Currency.Companion.make("ZWL", 2, 932)};
        all = SetsKt.hashSetOf((Object[])object);
        object = Companion.getAll();
        boolean bl = false;
        Map destination$iv = new HashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void it;
            Currency currency = (Currency)element$iv;
            Map map = destination$iv;
            boolean bl2 = false;
            CurrencyCode currencyCode = it.getCode();
            map.put(currencyCode, element$iv);
        }
        allByCode = var1_2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rJ \u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/fluidsonic/currency/Currency$Companion;", "", "()V", "all", "", "Lio/fluidsonic/currency/Currency;", "getAll", "()Ljava/util/Set;", "allByCode", "", "Lio/fluidsonic/currency/CurrencyCode;", "forCode", "code", "", "forCodeOrNull", "make", "defaultFractionDigits", "", "numericCode", "fluid-currency"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Currency> getAll() {
            return all;
        }

        private final Currency make(String code, int defaultFractionDigits, int numericCode) {
            return new Currency(new CurrencyCode(code), defaultFractionDigits, numericCode, null);
        }

        @NotNull
        public final Currency forCode(@NotNull CurrencyCode code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Currency currency = this.forCodeOrNull(code);
            if (currency == null) {
                String string = Intrinsics.stringPlus((String)"Invalid ISO 4217 currency code: ", (Object)code);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return currency;
        }

        @Nullable
        public final Currency forCodeOrNull(@NotNull CurrencyCode code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return (Currency)allByCode.get(code);
        }

        @NotNull
        public final Currency forCode(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Currency currency = this.forCodeOrNull(CurrencyCode.Companion.parse(code));
            if (currency == null) {
                String string = Intrinsics.stringPlus((String)"Invalid ISO 4217 currency code: ", (Object)code);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return currency;
        }

        @Nullable
        public final Currency forCodeOrNull(@NotNull String code) {
            Currency currency;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            CurrencyCode currencyCode = CurrencyCode.Companion.parseOrNull(code);
            if (currencyCode == null) {
                currency = null;
            } else {
                CurrencyCode currencyCode2 = currencyCode;
                boolean bl = false;
                boolean bl2 = false;
                CurrencyCode p0 = currencyCode2;
                boolean bl3 = false;
                currency = this.forCodeOrNull(p0);
            }
            return currency;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

