(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'fluid-currency-jsLegacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'fluid-currency-jsLegacy'.");
    }root['fluid-currency-jsLegacy'] = factory(typeof this['fluid-currency-jsLegacy'] === 'undefined' ? {} : this['fluid-currency-jsLegacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var getCallableRef = Kotlin.getCallableRef;
  var hashSetOf = Kotlin.kotlin.collections.hashSetOf_i5x0yv$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var HashMap_init = Kotlin.kotlin.collections.HashMap_init_q3lmfv$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var CharRange = Kotlin.kotlin.ranges.CharRange;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  function Currency(code, defaultFractionDigits, numericCode) {
    Currency$Companion_getInstance();
    this.code = code;
    this.defaultFractionDigits = defaultFractionDigits;
    this.numericCode = numericCode;
  }
  Currency.prototype.toString = function () {
    return this.code.toString();
  };
  function Currency$Companion() {
    Currency$Companion_instance = this;
    this.all = hashSetOf([this.make_0('AED', 2, 784), this.make_0('AFN', 2, 971), this.make_0('ALL', 2, 8), this.make_0('AMD', 2, 51), this.make_0('ANG', 2, 532), this.make_0('AOA', 2, 973), this.make_0('ARS', 2, 32), this.make_0('AUD', 2, 36), this.make_0('AWG', 2, 533), this.make_0('AZN', 2, 944), this.make_0('BAM', 2, 977), this.make_0('BBD', 2, 52), this.make_0('BDT', 2, 50), this.make_0('BGN', 2, 975), this.make_0('BHD', 3, 48), this.make_0('BIF', 0, 108), this.make_0('BMD', 2, 60), this.make_0('BND', 2, 96), this.make_0('BOB', 2, 68), this.make_0('BOV', 2, 984), this.make_0('BRL', 2, 986), this.make_0('BSD', 2, 44), this.make_0('BTN', 2, 64), this.make_0('BWP', 2, 72), this.make_0('BYN', 2, 933), this.make_0('BZD', 2, 84), this.make_0('CAD', 2, 124), this.make_0('CDF', 2, 976), this.make_0('CHE', 2, 947), this.make_0('CHF', 2, 756), this.make_0('CHW', 2, 948), this.make_0('CLF', 4, 990), this.make_0('CLP', 0, 152), this.make_0('CNY', 2, 156), this.make_0('COP', 2, 170), this.make_0('COU', 2, 970), this.make_0('CRC', 2, 188), this.make_0('CUC', 2, 931), this.make_0('CUP', 2, 192), this.make_0('CVE', 2, 132), this.make_0('CZK', 2, 203), this.make_0('DJF', 0, 262), this.make_0('DKK', 2, 208), this.make_0('DOP', 2, 214), this.make_0('DZD', 2, 12), this.make_0('EGP', 2, 818), this.make_0('ERN', 2, 232), this.make_0('ETB', 2, 230), this.make_0('EUR', 2, 978), this.make_0('FJD', 2, 242), this.make_0('FKP', 2, 238), this.make_0('GBP', 2, 826), this.make_0('GEL', 2, 981), this.make_0('GHS', 2, 936), this.make_0('GIP', 2, 292), this.make_0('GMD', 2, 270), this.make_0('GNF', 0, 324), this.make_0('GTQ', 2, 320), this.make_0('GYD', 2, 328), this.make_0('HKD', 2, 344), this.make_0('HNL', 2, 340), this.make_0('HRK', 2, 191), this.make_0('HTG', 2, 332), this.make_0('HUF', 2, 348), this.make_0('IDR', 2, 360), this.make_0('ILS', 2, 376), this.make_0('INR', 2, 356), this.make_0('IQD', 3, 368), this.make_0('IRR', 2, 364), this.make_0('ISK', 0, 352), this.make_0('JMD', 2, 388), this.make_0('JOD', 3, 400), this.make_0('JPY', 0, 392), this.make_0('KES', 2, 404), this.make_0('KGS', 2, 417), this.make_0('KHR', 2, 116), this.make_0('KMF', 0, 174), this.make_0('KPW', 2, 408), this.make_0('KRW', 0, 410), this.make_0('KWD', 3, 414), this.make_0('KYD', 2, 136), this.make_0('KZT', 2, 398), this.make_0('LAK', 2, 418), this.make_0('LBP', 2, 422), this.make_0('LKR', 2, 144), this.make_0('LRD', 2, 430), this.make_0('LSL', 2, 426), this.make_0('LYD', 3, 434), this.make_0('MAD', 2, 504), this.make_0('MDL', 2, 498), this.make_0('MGA', 2, 969), this.make_0('MKD', 2, 807), this.make_0('MMK', 2, 104), this.make_0('MNT', 2, 496), this.make_0('MOP', 2, 446), this.make_0('MRU', 2, 929), this.make_0('MUR', 2, 480), this.make_0('MVR', 2, 462), this.make_0('MWK', 2, 454), this.make_0('MXN', 2, 484), this.make_0('MXV', 2, 979), this.make_0('MYR', 2, 458), this.make_0('MZN', 2, 943), this.make_0('NAD', 2, 516), this.make_0('NGN', 2, 566), this.make_0('NIO', 2, 558), this.make_0('NOK', 2, 578), this.make_0('NPR', 2, 524), this.make_0('NZD', 2, 554), this.make_0('OMR', 3, 512), this.make_0('PAB', 2, 590), this.make_0('PEN', 2, 604), this.make_0('PGK', 2, 598), this.make_0('PHP', 2, 608), this.make_0('PKR', 2, 586), this.make_0('PLN', 2, 985), this.make_0('PYG', 0, 600), this.make_0('QAR', 2, 634), this.make_0('RON', 2, 946), this.make_0('RSD', 2, 941), this.make_0('RUB', 2, 643), this.make_0('RWF', 0, 646), this.make_0('SAR', 2, 682), this.make_0('SBD', 2, 90), this.make_0('SCR', 2, 690), this.make_0('SDG', 2, 938), this.make_0('SEK', 2, 752), this.make_0('SGD', 2, 702), this.make_0('SHP', 2, 654), this.make_0('SLL', 2, 694), this.make_0('SOS', 2, 706), this.make_0('SRD', 2, 968), this.make_0('SSP', 2, 728), this.make_0('STN', 2, 930), this.make_0('SVC', 2, 222), this.make_0('SYP', 2, 760), this.make_0('SZL', 2, 748), this.make_0('THB', 2, 764), this.make_0('TJS', 2, 972), this.make_0('TMT', 2, 934), this.make_0('TND', 3, 788), this.make_0('TOP', 2, 776), this.make_0('TRY', 2, 949), this.make_0('TTD', 2, 780), this.make_0('TWD', 2, 901), this.make_0('TZS', 2, 834), this.make_0('UAH', 2, 980), this.make_0('UGX', 0, 800), this.make_0('USD', 2, 840), this.make_0('USN', 2, 997), this.make_0('UYI', 0, 940), this.make_0('UYU', 2, 858), this.make_0('UYW', 4, 927), this.make_0('UZS', 2, 860), this.make_0('VES', 2, 928), this.make_0('VND', 0, 704), this.make_0('VUV', 0, 548), this.make_0('WST', 2, 882), this.make_0('XAF', 0, 950), this.make_0('XAG', -1, 961), this.make_0('XAU', -1, 959), this.make_0('XBA', -1, 955), this.make_0('XBB', -1, 956), this.make_0('XBC', -1, 957), this.make_0('XBD', -1, 958), this.make_0('XCD', 2, 951), this.make_0('XDR', -1, 960), this.make_0('XOF', 0, 952), this.make_0('XPD', -1, 964), this.make_0('XPF', 0, 953), this.make_0('XPT', -1, 962), this.make_0('XSU', -1, 994), this.make_0('XTS', -1, 963), this.make_0('XUA', -1, 965), this.make_0('XXX', -1, 999), this.make_0('YER', 2, 886), this.make_0('ZAR', 2, 710), this.make_0('ZMW', 2, 967), this.make_0('ZWL', 2, 932)]);
    var tmp$ = this.all;
    var destination = HashMap_init();
    var tmp$_0;
    tmp$_0 = tmp$.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      destination.put_xwzc9p$(element.code, element);
    }
    this.allByCode_0 = destination;
  }
  Currency$Companion.prototype.make_0 = function (code, defaultFractionDigits, numericCode) {
    return new Currency(new CurrencyCode(code), defaultFractionDigits, numericCode);
  };
  Currency$Companion.prototype.forCode_y4hqtl$ = function (code) {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = this.forCodeOrNull_y4hqtl$(code)) != null)
      tmp$_0 = tmp$;
    else {
      throw IllegalStateException_init(('Invalid ISO 4217 currency code: ' + code).toString());
    }
    return tmp$_0;
  };
  Currency$Companion.prototype.forCodeOrNull_y4hqtl$ = function (code) {
    return this.allByCode_0.get_11rb$(code);
  };
  Currency$Companion.prototype.forCode_61zpoe$ = function (code) {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = this.forCodeOrNull_y4hqtl$(CurrencyCode$Companion_getInstance().parse_61zpoe$(code))) != null)
      tmp$_0 = tmp$;
    else {
      throw IllegalStateException_init(('Invalid ISO 4217 currency code: ' + code).toString());
    }
    return tmp$_0;
  };
  Currency$Companion.prototype.forCodeOrNull_61zpoe$ = function (code) {
    var tmp$;
    return (tmp$ = CurrencyCode$Companion_getInstance().parseOrNull_61zpoe$(code)) != null ? getCallableRef('forCodeOrNull', function ($receiver, p1) {
      return $receiver.forCodeOrNull_y4hqtl$(p1);
    }.bind(null, this))(tmp$) : null;
  };
  Currency$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Currency$Companion_instance = null;
  function Currency$Companion_getInstance() {
    if (Currency$Companion_instance === null) {
      new Currency$Companion();
    }return Currency$Companion_instance;
  }
  Currency.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Currency',
    interfaces: []
  };
  function CurrencyCode(value) {
    CurrencyCode$Companion_getInstance();
    this.value_0 = value;
  }
  CurrencyCode.prototype.isValid = function () {
    return Currency$Companion_getInstance().forCodeOrNull_y4hqtl$(this) != null;
  };
  CurrencyCode.prototype.toString = function () {
    return this.value_0;
  };
  function CurrencyCode$Companion() {
    CurrencyCode$Companion_instance = this;
  }
  CurrencyCode$Companion.prototype.parse_61zpoe$ = function (string) {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = this.parseOrNull_61zpoe$(string)) != null)
      tmp$_0 = tmp$;
    else {
      throw IllegalStateException_init(('Invalid ISO 4217 currency code format: ' + string).toString());
    }
    return tmp$_0;
  };
  CurrencyCode$Companion.prototype.parseOrNull_61zpoe$ = function (string) {
    var tmp$;
    return (tmp$ = getCallableRef('isValidFormat', function ($receiver, p1) {
      return $receiver.isValidFormat_0(p1);
    }.bind(null, this))(string) ? string : null) != null ? new CurrencyCode(tmp$.toUpperCase()) : null;
  };
  CurrencyCode$Companion.prototype.isValidFormat_0 = function (string) {
    return string.length === 3 && isLatinLetter(string.charCodeAt(0)) && isLatinLetter(string.charCodeAt(1)) && isLatinLetter(string.charCodeAt(2));
  };
  CurrencyCode$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CurrencyCode$Companion_instance = null;
  function CurrencyCode$Companion_getInstance() {
    if (CurrencyCode$Companion_instance === null) {
      new CurrencyCode$Companion();
    }return CurrencyCode$Companion_instance;
  }
  CurrencyCode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CurrencyCode',
    interfaces: []
  };
  CurrencyCode.prototype.unbox = function () {
    return this.value_0;
  };
  CurrencyCode.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value_0) | 0;
    return result;
  };
  CurrencyCode.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value_0, other.value_0))));
  };
  function isLatinLetter($receiver) {
    return (new CharRange(97, 122)).contains_mef7kx$($receiver) || (new CharRange(65, 90)).contains_mef7kx$($receiver);
  }
  var freeze = defineInlineFunction('fluid-currency-jsLegacy.io.fluidsonic.currency.freeze_8ea4r1$', function ($receiver) {
  });
  Object.defineProperty(Currency, 'Companion', {
    get: Currency$Companion_getInstance
  });
  $$importsForInline$$['fluid-currency-jsLegacy'] = _;
  var package$io = _.io || (_.io = {});
  var package$fluidsonic = package$io.fluidsonic || (package$io.fluidsonic = {});
  var package$currency = package$fluidsonic.currency || (package$fluidsonic.currency = {});
  package$currency.Currency = Currency;
  Object.defineProperty(CurrencyCode, 'Companion', {
    get: CurrencyCode$Companion_getInstance
  });
  package$currency.CurrencyCode = CurrencyCode;
  package$currency.isLatinLetter_nupfqh$ = isLatinLetter;
  package$currency.freeze_8ea4r1$ = freeze;
  Kotlin.defineModule('fluid-currency-jsLegacy', _);
  return _;
}));

//# sourceMappingURL=fluid-currency-jsLegacy.js.map
