/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client;

import com.flowthings.client.SortType;
import java.util.HashMap;
import java.util.Map;

public class QueryOptions {
    public static final int DEFAULT_BATCH_SIZE = 20;
    public static final int DEFAULT_LIMIT_SIZE = 20;
    public static final int NO_LIMIT = Integer.MAX_VALUE;
    protected Map<String, SortType> sorts = new HashMap<String, SortType>();
    protected Integer skip;
    protected Integer limit;
    protected String filter;
    protected Map<String, String> other = new HashMap<String, String>();

    public QueryOptions sort(String sort, SortType sortType) {
        this.sorts.clear();
        this.sorts.put(sort, sortType);
        return this;
    }

    public QueryOptions skip(int ct) {
        this.skip = ct;
        return this;
    }

    public QueryOptions limit(int ct) {
        this.limit = ct;
        return this;
    }

    public QueryOptions filter(String filterStr) {
        this.filter = filterStr;
        return this;
    }

    public void addOtherOption(String key, String value) {
        this.other.put(key, value);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> results = new HashMap<String, String>();
        if (this.skip != null) {
            results.put("skip", this.skip.toString());
        }
        if (this.limit != null) {
            results.put("limit", this.limit.toString());
        }
        if (this.filter != null) {
            results.put("filter", this.filter.toString());
        }
        if (!this.sorts.isEmpty()) {
            results.put("sort", this.sorts.keySet().iterator().next());
            results.put("order", this.sorts.values().iterator().next().toString());
        }
        for (String key : this.other.keySet()) {
            results.put(key, this.other.get(key));
        }
        return results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryOptions that = (QueryOptions)o;
        if (this.sorts != null ? !this.sorts.equals(that.sorts) : that.sorts != null) {
            return false;
        }
        if (this.skip != null ? !this.skip.equals(that.skip) : that.skip != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        return !(this.filter == null ? that.filter != null : !this.filter.equals(that.filter));
    }

    public int hashCode() {
        int result = this.sorts != null ? this.sorts.hashCode() : 0;
        result = 31 * result + (this.skip != null ? this.skip.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }
}

