/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client;

import com.flowthings.client.Serializer;
import com.flowthings.client.VcapServices;
import com.google.gson.reflect.TypeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Credentials {
    protected static Logger logger = LoggerFactory.getLogger(Credentials.class);
    public String account;
    public String token;

    public Credentials(String account, String token) {
        this.account = account;
        this.token = token;
    }

    public Credentials() {
    }

    public boolean masterTokenSupplied() {
        return this.token != null && this.token.length() == 32;
    }

    public String toString() {
        return "Credentials [account=" + this.account + ", token=" + this.token + "]";
    }

    public static Credentials fromBluemixOrDefault(Credentials defaultCredentials) {
        String VCAP_SERVICES = System.getenv("VCAP_SERVICES");
        logger.info(VCAP_SERVICES);
        if (VCAP_SERVICES != null) {
            try {
                VcapServices services = Serializer.fromJson(VCAP_SERVICES, new TypeToken<VcapServices>(){});
                if (services.flowthings != null && !services.flowthings.isEmpty()) {
                    return services.flowthings.get((int)0).credentials;
                }
            }
            catch (Exception e) {
                logger.info("Couldn't deserialize bluemix VCAP_SERVICES");
            }
        }
        logger.info("Using default credentials : " + defaultCredentials);
        return defaultCredentials;
    }

    public static void main(String[] args) {
        logger.info("Got creds: " + Credentials.fromBluemixOrDefault(null));
    }
}

