/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client.api;

import com.flowthings.client.Credentials;
import com.flowthings.client.api.FlowthingsFuture;
import com.flowthings.client.api.Request;
import com.flowthings.client.api.SubscriptionCallback;
import com.flowthings.client.api.WebsocketApi;
import com.flowthings.client.api.WebsocketsDropResponse;
import com.flowthings.client.domain.Drop;
import com.flowthings.client.domain.Types;
import com.flowthings.client.exception.ConnectionRefusedException;
import com.flowthings.client.exception.FlowthingsException;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class MockWebsocketApi
extends WebsocketApi {
    private boolean canConnect = true;
    private ConcurrentHashMap<Request, Callable> answers = new ConcurrentHashMap();
    private ConcurrentHashMap<Request, AtomicInteger> counters = new ConcurrentHashMap();
    private ExecutorService pool = Executors.newCachedThreadPool();

    public MockWebsocketApi(boolean canConnect) throws FlowthingsException {
        super(new Credentials("a", "b"));
        this.canConnect = canConnect;
    }

    public void setCanConnect(boolean canConnect) {
        this.canConnect = canConnect;
        if (!canConnect && this.socket != null) {
            this.socket.close();
        }
    }

    public MockWebsocketApi setAnswer(Request request, Callable response) {
        this.answers.put(request, response);
        return this;
    }

    public MockWebsocketApi setAnswers(Request request, Object ... responses) {
        AtomicInteger counter = new AtomicInteger();
        this.answers.put(request, () -> {
            int i = counter.getAndIncrement();
            Object response = responses[i = Math.min(responses.length - 1, i)];
            if (response instanceof FlowthingsException) {
                throw (FlowthingsException)response;
            }
            return response;
        });
        return this;
    }

    public MockWebsocketApi setException(Request request, FlowthingsException response) {
        this.answers.put(request, () -> {
            throw response;
        });
        return this;
    }

    public MockWebsocketApi setAnswerImmediately(Request request, Object response) {
        this.answers.put(request, () -> response);
        return this;
    }

    public void supplyIncomingDrop(String flowId, Drop drop) {
        WebsocketsDropResponse r1 = new WebsocketsDropResponse();
        r1.setResource(flowId);
        r1.setType("drop");
        r1.setValue(drop);
        this.onWebsocketsDropResponse(r1);
    }

    @Override
    protected <S> FlowthingsFuture<S> sendRequest(Request<S> request) {
        Request.Action action = request.action;
        Types type = request.type;
        Callable provider = this.answers.get(request);
        if (request.action == Request.Action.SUBSCRIBE) {
            SubscriptionCallback callback = (SubscriptionCallback)request.otherData.get("callback");
            this.subscriptions.put(request.flowId, callback);
        } else if (request.action == Request.Action.UNSUBSCRIBE) {
            this.subscriptions.remove(request.flowId);
        }
        AtomicInteger v = new AtomicInteger(0);
        AtomicInteger i = this.counters.putIfAbsent(request, v);
        if (i == null) {
            i = v;
        }
        i.incrementAndGet();
        System.out.println(action.toString() + "|" + type.toString());
        if (provider != null) {
            Future future = this.pool.submit(provider);
            return new FlowthingsFuture(future);
        }
        return new FlowthingsFuture(SettableFuture.create());
    }

    public int getCounter(Request request) {
        return this.counters.getOrDefault(request, new AtomicInteger(0)).get();
    }

    @Override
    protected WebsocketApi.Socket connectWs(String sessionId) throws FlowthingsException {
        if (this.canConnect) {
            return new MockSocket();
        }
        throw new ConnectionRefusedException("Mock Connection - cannot connect");
    }

    @Override
    protected String connectHttp() throws FlowthingsException {
        return "beepboop";
    }

    public class MockSocket
    implements WebsocketApi.Socket {
        private CountDownLatch latch = new CountDownLatch(1);

        @Override
        public void close() {
            this.latch.countDown();
        }

        @Override
        public void send(String message) throws FlowthingsException {
        }

        @Override
        public void join() throws InterruptedException {
            this.latch.await();
        }
    }
}

