/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client.api;

import com.flowthings.client.Credentials;
import com.flowthings.client.api.FlowthingsFuture;
import com.flowthings.client.api.Request;
import com.flowthings.client.api.RestApi;
import com.flowthings.client.domain.Types;
import com.flowthings.client.exception.FlowthingsException;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class MockRestApi
extends RestApi {
    private boolean canConnect = true;
    private ConcurrentHashMap<Request, Callable> answers = new ConcurrentHashMap();
    private ConcurrentHashMap<Request, AtomicInteger> counters = new ConcurrentHashMap();
    private ExecutorService pool = Executors.newCachedThreadPool();

    public MockRestApi() throws FlowthingsException {
        super(new Credentials("a", "b"));
    }

    public MockRestApi setAnswer(Request request, Callable response) {
        this.answers.put(request, response);
        return this;
    }

    public MockRestApi setAnswers(Request request, Object ... responses) {
        AtomicInteger counter = new AtomicInteger();
        this.answers.put(request, () -> {
            int i = counter.getAndIncrement();
            Object response = responses[i = Math.min(responses.length - 1, i)];
            if (response instanceof FlowthingsException) {
                throw (FlowthingsException)response;
            }
            return response;
        });
        return this;
    }

    public MockRestApi setException(Request request, FlowthingsException response) {
        this.answers.put(request, () -> {
            throw response;
        });
        return this;
    }

    public MockRestApi setAnswerImmediately(Request request, Object response) {
        this.answers.put(request, () -> response);
        return this;
    }

    @Override
    public <S> FlowthingsFuture<S> sendAsync(Request<S> request) {
        Request.Action action = request.action;
        Types type = request.type;
        Callable provider = this.answers.get(request);
        this.counters.compute(request, (k, v) -> {
            if (v == null) {
                return new AtomicInteger(0);
            }
            v.incrementAndGet();
            return v;
        });
        if (provider != null) {
            Future future = this.pool.submit(provider);
            return new FlowthingsFuture(future);
        }
        return new FlowthingsFuture(SettableFuture.create());
    }

    public int getCounter(Request request) {
        return this.counters.getOrDefault(request, new AtomicInteger(0)).get();
    }
}

