/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client;

import com.flowthings.client.DropElementSerializer;
import com.flowthings.client.domain.DropElementsMap;
import com.flowthings.client.domain.FlowDomainObject;
import com.flowthings.client.domain.Permissions;
import com.flowthings.client.domain.TokenPermissions;
import com.flowthings.client.domain.Types;
import com.flowthings.client.response.ListResponse;
import com.flowthings.client.response.MapResponse;
import com.flowthings.client.response.ObjectResponse;
import com.flowthings.client.response.Response;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Serializer {
    protected static Logger logger = Logger.getLogger("com.flow.client.Serializer");
    public static Gson gson = Serializer.createGsonSerializer();
    private static TypeToken<ParseToken> innerParseToken = new TypeToken<ParseToken>(){};

    public static String toJson(Object o) {
        return o == null ? "" : gson.toJson(o, o.getClass());
    }

    public static String toJson(String key, Object o) {
        return o == null ? "" : String.format("{\"%s\":%s}", key, gson.toJson(o, o.getClass()));
    }

    public static <T extends FlowDomainObject> ObjectResponse<T> fromJsonResponse(String s, Class<T> klazz) {
        return (ObjectResponse)gson.fromJson(s, Types.get(klazz).tokenType);
    }

    public static MapResponse fromJsonMapResponse(String json, String key, Type t) {
        ParseToken p = (ParseToken)gson.fromJson(json, innerParseToken.getType());
        Object inner = gson.fromJson(p.value, t);
        return new MapResponse(p.head, key, inner);
    }

    public static <T> T fromJson(String s, Class<T> klazz) {
        return (T)gson.fromJson(s, klazz);
    }

    public static <T> T fromJson(String s, TypeToken<T> t) {
        return (T)gson.fromJson(s, t.getType());
    }

    private static Gson createGsonSerializer() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        builder.registerTypeAdapter(ListResponse.ERROR.class, (Object)new JsonDeserializer<ListResponse.ERROR>(){

            public ListResponse.ERROR deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                ListResponse.ERROR r = new ListResponse.ERROR();
                JsonObject jo = (JsonObject)json;
                JsonElement head = jo.remove("head");
                r.setHead((Response.Head)context.deserialize(head, Response.Head.class));
                return r;
            }
        });
        builder.registerTypeAdapter(ObjectResponse.ERROR.class, (Object)new JsonDeserializer<ObjectResponse.ERROR>(){

            public ObjectResponse.ERROR deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                ObjectResponse.ERROR r = new ObjectResponse.ERROR();
                JsonObject jo = (JsonObject)json;
                JsonElement head = jo.remove("head");
                r.setHead((Response.Head)context.deserialize(head, Response.Head.class));
                return r;
            }
        });
        builder.registerTypeAdapter(ParseToken.class, (Object)new JsonDeserializer<ParseToken>(){

            public ParseToken deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject body;
                Iterator iter;
                ParseToken r = new ParseToken();
                JsonObject jo = (JsonObject)json;
                JsonElement head = jo.remove("head");
                r.head = (Response.Head)context.deserialize(head, Response.Head.class);
                JsonElement je = jo.get("body");
                if (je instanceof JsonObject && (iter = (body = (JsonObject)je).entrySet().iterator()).hasNext()) {
                    Map.Entry first = (Map.Entry)iter.next();
                    r.value = ((JsonElement)first.getValue()).toString();
                }
                return r;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive((Number)src.getTime());
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Date d = new Date();
                d.setTime(json.getAsLong());
                return d;
            }
        });
        builder.registerTypeAdapter(Permissions.class, (Object)new JsonDeserializer<Permissions>(){

            public Permissions deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    JsonObject map = (JsonObject)json;
                    JsonElement readObj = map.get("read");
                    JsonElement writeObj = map.get("write");
                    JsonElement dropReadObj = map.get("dropRead");
                    JsonElement dropWriteObj = map.get("dropWrite");
                    boolean read = readObj == null ? false : readObj.getAsBoolean();
                    boolean write = writeObj == null ? false : writeObj.getAsBoolean();
                    boolean dropRead = dropReadObj == null ? false : dropReadObj.getAsBoolean();
                    boolean dropWrite = dropWriteObj == null ? false : dropWriteObj.getAsBoolean();
                    return new Permissions(read, write, dropRead, dropWrite);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Couldn't deserialize " + json + " as permissions");
                    return null;
                }
            }
        });
        builder.registerTypeAdapter(TokenPermissions.class, (Object)new JsonDeserializer<TokenPermissions>(){

            public TokenPermissions deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    JsonObject map = (JsonObject)json;
                    JsonElement dropReadObj = map.get("dropRead");
                    JsonElement dropWriteObj = map.get("dropWrite");
                    boolean dropRead = dropReadObj == null ? false : dropReadObj.getAsBoolean();
                    boolean dropWrite = dropWriteObj == null ? false : dropWriteObj.getAsBoolean();
                    return new TokenPermissions(dropRead, dropWrite);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Couldn't deserialize " + json + " as token permissions");
                    return null;
                }
            }
        });
        builder.registerTypeAdapter(DropElementsMap.class, (Object)new JsonSerializer<DropElementsMap>(){

            public JsonElement serialize(DropElementsMap src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject o = new JsonObject();
                for (Map.Entry entry : src.entrySet()) {
                    o.add((String)entry.getKey(), DropElementSerializer.toJsonElement(entry.getValue()));
                }
                return o;
            }
        });
        builder.registerTypeAdapter(DropElementsMap.class, (Object)new JsonDeserializer<DropElementsMap>(){

            public DropElementsMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                DropElementsMap d = new DropElementsMap();
                JsonObject map = (JsonObject)json;
                for (Map.Entry e : map.entrySet()) {
                    d.put(e.getKey(), DropElementSerializer.fromJsonElement((JsonElement)e.getValue()));
                }
                return d;
            }
        });
        return builder.create();
    }

    public static class ParseToken {
        public String value;
        public Response.Head head;
    }
}

