/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client.domain.elements;

import com.flowthings.client.domain.elements.MapLike;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Media
implements MapLike {
    protected Map<String, Object> fields = new HashMap<String, Object>();

    @Override
    public void put(String key, Object value) {
        this.fields.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.fields.get(key);
    }

    @Override
    public Iterator<String> iterator() {
        return this.fields.keySet().iterator();
    }

    @Override
    public String getType() {
        return "media";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Media other = (Media)obj;
        return !(this.fields == null ? other.fields != null : !this.fields.equals(other.fields));
    }

    public String toString() {
        return "Media [fields=" + this.fields + "]";
    }

    public static class Builder {
        protected Media base = new Media();

        public Builder setThumbnailHeight(Integer thumbnailHeight) {
            this.base.put("thumbnailHeight", thumbnailHeight);
            return this;
        }

        public Builder setThumbnailWidth(Integer thumbnailWidth) {
            this.base.put("thumbnailWidth", thumbnailWidth);
            return this;
        }

        public Builder setThumbnailUrl(String thumbnailUrl) {
            this.base.put("thumbnailUrl", thumbnailUrl);
            return this;
        }

        public Builder setCacheAge(String cacheAge) {
            this.base.put("cacheAge", cacheAge);
            return this;
        }

        public Builder setHtml(String html) {
            this.base.put("html", html);
            return this;
        }

        public Builder setAuthorUrl(String authorUrl) {
            this.base.put("authorUrl", authorUrl);
            return this;
        }

        public Builder setAuthorName(String authorName) {
            this.base.put("authorName", authorName);
            return this;
        }

        public Builder setHeight(Integer height) {
            this.base.put("height", height);
            return this;
        }

        public Builder setWidth(Integer width) {
            this.base.put("width", width);
            return this;
        }

        public Builder setProviderUrl(String providerUrl) {
            this.base.put("provider_url", providerUrl);
            return this;
        }

        public Builder setProviderName(String providerName) {
            this.base.put("provider_name", providerName);
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.base.put("mime_type", mimeType);
            return this;
        }

        public Builder setMediaType(MEDIA_TYPE mediaType) {
            this.base.put("media_type", mediaType == null ? null : mediaType.name().toLowerCase());
            return this;
        }

        public Builder setVersion(String version) {
            this.base.put("version", version);
            return this;
        }

        public Builder setDescription(String description) {
            this.base.put("description", description);
            return this;
        }

        public Builder setUrl(String url) {
            this.base.put("url", url);
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.base.put("displayName", displayName);
            return this;
        }
    }

    private static enum MEDIA_TYPE {
        VIDEO,
        LINK,
        RICH,
        PHOTO;

    }
}

