/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client.api;

import com.flowthings.client.Credentials;
import com.flowthings.client.Header;
import com.flowthings.client.Serializer;
import com.flowthings.client.api.Api;
import com.flowthings.client.api.Request;
import com.flowthings.client.exception.AuthorizationException;
import com.flowthings.client.exception.BadRequestException;
import com.flowthings.client.exception.FlowthingsException;
import com.flowthings.client.exception.NotFoundException;
import com.flowthings.client.response.ListResponse;
import com.flowthings.client.response.ObjectResponse;
import com.flowthings.client.response.Response;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class RestApi
extends Api {
    protected static Logger logger = Logger.getLogger("com.flow.client.api.RestApi");
    private Credentials credentials;
    private String url;
    private static Map<Request.Action, String> methods = new HashMap<Request.Action, String>();

    public RestApi(Credentials credentials) {
        this(credentials, "https://api.flowthings.io/v0.1");
    }

    public RestApi(Credentials credentials, String url) {
        this.credentials = credentials;
        this.url = url;
    }

    public <S> S send(Request<S> request) throws FlowthingsException {
        try {
            String queryString = this.toQueryString(request.buildHttpPath(this.credentials, this.url), request.queryOptions.toMap());
            HttpURLConnection connection = (HttpURLConnection)new URL(queryString).openConnection();
            String method = methods.get((Object)request.action);
            if (method == null) {
                throw new FlowthingsException("Cannot send " + (Object)((Object)request.action) + " using the RestAPI");
            }
            Map<String, Object> headers = new Header(this.credentials).toMap();
            this.setRequestProperties(connection, headers);
            connection.setDoInput(true);
            connection.setRequestMethod(method.toString());
            if (request.body != null) {
                connection.setDoOutput(true);
                try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
                    out.writeBytes(request.body);
                    out.flush();
                }
            }
            String stringResponse = null;
            try {
                stringResponse = this.collectResponse(connection.getInputStream());
                Response response = Serializer.fromJson(stringResponse, request.typeToken);
                int status = response.getHead().getStatus();
                if (response.getHead().isOk()) {
                    return response.getBody();
                }
                if (status == 404) {
                    throw new NotFoundException(response.getHead().getErrors().get(0));
                }
                if (status == 403) {
                    throw new AuthorizationException(response.getHead().getErrors().get(0));
                }
                throw new BadRequestException(response.getHead().getErrors().get(0));
            }
            catch (Exception e) {
                stringResponse = this.collectResponse(connection.getErrorStream());
                Response response = Serializer.fromJson(stringResponse, request.listResponse ? ListResponse.ERROR.class : ObjectResponse.ERROR.class);
                int status = response.getHead().getStatus();
                if (status == 404) {
                    throw new NotFoundException(response.getHead().getErrors().get(0));
                }
                if (status == 403) {
                    throw new AuthorizationException(response.getHead().getErrors().get(0));
                }
                throw new BadRequestException(response.getHead().getErrors().get(0));
            }
        }
        catch (IOException e) {
            throw new FlowthingsException(e);
        }
    }

    protected String toQueryString(String url, Map<String, String> parameters) throws UnsupportedEncodingException {
        if (parameters == null || parameters.isEmpty()) {
            return url;
        }
        StringBuilder b = new StringBuilder(url).append('?');
        Iterator<Map.Entry<String, String>> iter = parameters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> e = iter.next();
            b.append(URLEncoder.encode(e.getKey(), "UTF-8") + "=" + URLEncoder.encode(e.getValue(), "UTF-8"));
            if (!iter.hasNext()) continue;
            b.append('&');
        }
        return b.toString();
    }

    static {
        methods.put(Request.Action.CREATE, "POST");
        methods.put(Request.Action.DELETE, "DELETE");
        methods.put(Request.Action.FIND, "GET");
        methods.put(Request.Action.UPDATE, "PUT");
        methods.put(Request.Action.GET, "GET");
    }
}

