/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client.api;

import com.flowthings.client.Credentials;
import com.flowthings.client.QueryOptions;
import com.flowthings.client.Serializer;
import com.flowthings.client.domain.Types;
import com.flowthings.client.response.Response;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Request<S> {
    private static final Pattern ID_PATTERN = Pattern.compile("[a-z][0-9a-f]{24}");
    protected static Logger logger = Logger.getLogger("com.flow.client.Request");
    protected String id;
    protected QueryOptions queryOptions = new QueryOptions();
    protected String body;
    protected TypeToken<? extends Response<S>> typeToken;
    protected Action action;
    protected Types type;
    protected String member;
    protected String flowId;
    protected boolean listResponse;
    protected S bodyObject;
    protected Map<String, Object> otherData = new HashMap<String, Object>();

    public static <S> Request<S> createObjectRequest(Class<S> domainObjectType, Action action) {
        Types type = Types.get(domainObjectType);
        return new Request<S>(action, type, type.token, false);
    }

    public static <S> Request<List<S>> createListRequest(Class<S> domainObjectType, Action action) {
        Types type = Types.getListType(domainObjectType);
        return new Request<List<S>>(action, type, type.token, true);
    }

    public Request(Action action, Types type, TypeToken<? extends Response<S>> typeToken, boolean listResponse) {
        this.action = action;
        this.type = type;
        this.typeToken = typeToken;
        this.listResponse = listResponse;
    }

    public Request<S> member(String member) {
        this.member = member;
        return this;
    }

    public Request<S> id(String id) {
        if (!ID_PATTERN.matcher(id).matches()) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid id", id));
        }
        this.id = id;
        return this;
    }

    public Request<S> flowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    public Request<S> params(QueryOptions queryOptions) {
        this.queryOptions = queryOptions;
        return this;
    }

    public Request<S> body(S s) {
        this.bodyObject = s;
        this.body = Serializer.toJson(s);
        return this;
    }

    public Request<S> addData(String k, Object o) {
        this.otherData.put(k, o);
        return this;
    }

    public String buildHttpPath(Credentials credentials, String url) {
        StringBuffer sb = new StringBuffer(url);
        sb.append("/").append(credentials.account).append("/").append(this.type.name);
        if (this.flowId != null) {
            sb.append("/").append(this.flowId);
        }
        if (this.id != null) {
            sb.append("/").append(this.id);
            if (this.member != null) {
                sb.append("/").append(this.member);
            }
        }
        return sb.toString();
    }

    public static enum Action {
        CREATE,
        UPDATE,
        DELETE,
        GET,
        FIND,
        SUBSCRIBE,
        UNSUBSCRIBE;

    }
}

