/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client;

import com.flowthings.client.SortType;
import java.util.HashMap;
import java.util.Map;

public class QueryOptions {
    public static final int DEFAULT_BATCH_SIZE = 20;
    public static final int DEFAULT_LIMIT_SIZE = 20;
    public static final int NO_LIMIT = Integer.MAX_VALUE;
    protected Map<String, SortType> sorts = new HashMap<String, SortType>();
    protected Integer skip;
    protected Integer limit;
    protected String filter;

    public QueryOptions sort(String sort, SortType sortType) {
        this.sorts.clear();
        this.sorts.put(sort, sortType);
        return this;
    }

    public QueryOptions skip(int ct) {
        this.skip = ct;
        return this;
    }

    public QueryOptions limit(int ct) {
        this.limit = ct;
        return this;
    }

    public QueryOptions filter(String filterStr) {
        this.filter = filterStr;
        return this;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> results = new HashMap<String, String>();
        if (this.skip != null) {
            results.put("skip", this.skip.toString());
        }
        if (this.limit != null) {
            results.put("limit", this.limit.toString());
        }
        if (this.filter != null) {
            results.put("filter", this.filter.toString());
        }
        if (!this.sorts.isEmpty()) {
            results.put("sort", this.sorts.keySet().iterator().next());
            results.put("order", this.sorts.values().iterator().next().toString());
        }
        return results;
    }
}

