/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client.domain.elements;

public class Duration {
    public final Units units;
    public final double magnitude;

    public Duration(Units units, double magnitude) {
        this.units = units;
        this.magnitude = magnitude;
    }

    public Units getUnits() {
        return this.units;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.magnitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.units == null ? 0 : this.units.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Duration other = (Duration)obj;
        if (Double.doubleToLongBits(this.magnitude) != Double.doubleToLongBits(other.magnitude)) {
            return false;
        }
        return this.units == other.units;
    }

    public String toString() {
        return "Duration [units=" + (Object)((Object)this.units) + ", magnitude=" + this.magnitude + "]";
    }

    public static enum Units {
        MILLISECONDS,
        SECONDS,
        MINUTES,
        HOURS,
        DAYS;

    }
}

