/*
 * Decompiled with CFR 0.152.
 */
package io.florianlopes.spring.test.web.servlet.request;

import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MockMvcRequestBuilderUtils {
    private static final PropertyEditorRegistrySupport PROPERTY_EDITOR_REGISTRY = new SimpleTypeConverter();
    private static final Configuration DEFAULT_CONFIG = Configuration.builder().includeFinal(true).includeTransient(false).includeStatic(false).build();
    private static final Logger LOGGER = LoggerFactory.getLogger(MockMvcRequestBuilderUtils.class);

    private MockMvcRequestBuilderUtils() {
    }

    public static void registerPropertyEditor(Class type, PropertyEditor propertyEditor) {
        PROPERTY_EDITOR_REGISTRY.registerCustomEditor(type, propertyEditor);
    }

    public static FormRequestPostProcessor form(Object form) {
        return MockMvcRequestBuilderUtils.form(form, DEFAULT_CONFIG);
    }

    public static FormRequestPostProcessor form(Object form, Configuration config) {
        return new FormRequestPostProcessor(form, config);
    }

    public static MockHttpServletRequestBuilder postForm(String url, Object form) {
        return MockMvcRequestBuilderUtils.postForm(url, form, DEFAULT_CONFIG);
    }

    public static MockHttpServletRequestBuilder postForm(String url, Object form, Configuration config) {
        MockHttpServletRequestBuilder mockHttpServletRequestBuilder = MockMvcRequestBuilders.post((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED);
        return MockMvcRequestBuilderUtils.buildFormFields(form, mockHttpServletRequestBuilder, config);
    }

    public static MockHttpServletRequestBuilder putForm(String url, Object form) {
        return MockMvcRequestBuilderUtils.putForm(url, form, DEFAULT_CONFIG);
    }

    public static MockHttpServletRequestBuilder putForm(String url, Object form, Configuration config) {
        MockHttpServletRequestBuilder mockHttpServletRequestBuilder = MockMvcRequestBuilders.put((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED);
        return MockMvcRequestBuilderUtils.buildFormFields(form, mockHttpServletRequestBuilder, config);
    }

    private static MockHttpServletRequestBuilder buildFormFields(Object form, MockHttpServletRequestBuilder mockHttpServletRequestBuilder, Configuration config) {
        Map<String, String> formFields = MockMvcRequestBuilderUtils.getFormFields(form, new TreeMap<String, String>(), "", config);
        formFields.forEach((path, value) -> {
            LOGGER.debug("Adding form field ({}={}) to HTTP request parameters", path, value);
            mockHttpServletRequestBuilder.param(path, new String[]{value});
        });
        return mockHttpServletRequestBuilder;
    }

    private static Map<String, String> getFormFields(Object form, Map<String, String> formFields, String path, Configuration config) {
        List<Object> fields = form != null ? MockMvcRequestBuilderUtils.getFormFields(form, config) : new ArrayList();
        for (Field field : fields) {
            Class<?> fieldType = field.getType();
            Object fieldValue = MockMvcRequestBuilderUtils.getFieldValue(form, field);
            if (fieldValue == null) continue;
            if (MockMvcRequestBuilderUtils.isIterable(fieldType)) {
                Iterable<?> iterableObject = MockMvcRequestBuilderUtils.getIterable(fieldValue, fieldType);
                if (iterableObject == null) continue;
                if (MockMvcRequestBuilderUtils.isComplexField(field)) {
                    int i = 0;
                    for (Object object : iterableObject) {
                        String nestedPath = MockMvcRequestBuilderUtils.getPositionedField(path, field, i) + ".";
                        formFields.putAll(MockMvcRequestBuilderUtils.getFormFields(object, formFields, nestedPath, config));
                        ++i;
                    }
                    continue;
                }
                formFields.putAll(MockMvcRequestBuilderUtils.getCollectionFields(iterableObject, path, field));
                continue;
            }
            if (MockMvcRequestBuilderUtils.isMap(fieldType)) {
                Map<?, ?> map = MockMvcRequestBuilderUtils.getMap(fieldValue, fieldType);
                if (map == null) continue;
                map.forEach((key, value) -> formFields.put(MockMvcRequestBuilderUtils.getPositionedField(path, field, MockMvcRequestBuilderUtils.getStringValue(key)), MockMvcRequestBuilderUtils.getStringValue(value)));
                continue;
            }
            if (!MockMvcRequestBuilderUtils.isComplexField(field) || MockMvcRequestBuilderUtils.hasPropertyEditorFor(fieldType)) {
                formFields.put(path + field.getName(), MockMvcRequestBuilderUtils.getStringValue(fieldValue));
                continue;
            }
            String nestedPath = MockMvcRequestBuilderUtils.getNestedPath(field);
            formFields.putAll(MockMvcRequestBuilderUtils.getFormFields(ReflectionTestUtils.getField((Object)form, (String)field.getName()), formFields, nestedPath, config));
        }
        return formFields;
    }

    private static List<Field> getFormFields(Object form, Configuration config) {
        return FieldUtils.getAllFieldsList(form.getClass()).stream().filter(config.fieldPredicate).collect(Collectors.toList());
    }

    private static Map<?, ?> getMap(Object fieldValue, Class<?> type) {
        return Map.class.isAssignableFrom(type) ? (Map)fieldValue : null;
    }

    private static Iterable<?> getIterable(Object fieldValue, Class<?> type) {
        return Iterable.class.isAssignableFrom(type) ? (Iterable)fieldValue : CollectionUtils.arrayToList((Object)fieldValue);
    }

    private static Map<String, String> getCollectionFields(Iterable<?> iterable, String path, Field field) {
        TreeMap<String, String> fields = new TreeMap<String, String>();
        int i = 0;
        for (Object object : iterable) {
            fields.put(MockMvcRequestBuilderUtils.getPositionedField(path, field, i), MockMvcRequestBuilderUtils.getStringValue(object));
            ++i;
        }
        return fields;
    }

    private static String getPositionedField(String path, Field field, int position) {
        return MockMvcRequestBuilderUtils.getPositionedField(path, field, String.valueOf(position));
    }

    private static String getPositionedField(String path, Field field, String positionOrKey) {
        return String.format("%s%s[%s]", path, field.getName(), positionOrKey);
    }

    private static String getNestedPath(Field field) {
        return field.getName() + ".";
    }

    private static Object getFieldValue(Object form, Field field) {
        return ReflectionTestUtils.getField((Object)form, (String)field.getName());
    }

    private static String getStringValue(Object object) {
        if (object != null) {
            PropertyEditor propertyEditor = MockMvcRequestBuilderUtils.getPropertyEditorFor(object);
            if (propertyEditor != null) {
                propertyEditor.setValue(object);
                return propertyEditor.getAsText();
            }
            return String.valueOf(object);
        }
        return "";
    }

    private static boolean hasPropertyEditorFor(Class<?> type) {
        return PROPERTY_EDITOR_REGISTRY.hasCustomEditorForElement(type, null) || PROPERTY_EDITOR_REGISTRY.getDefaultEditor(type) != null;
    }

    private static PropertyEditor getPropertyEditorFor(Object object) {
        return PROPERTY_EDITOR_REGISTRY.hasCustomEditorForElement(object.getClass(), null) ? PROPERTY_EDITOR_REGISTRY.findCustomEditor(object.getClass(), null) : PROPERTY_EDITOR_REGISTRY.getDefaultEditor(object.getClass());
    }

    private static boolean isComplexField(Field field) {
        if (MockMvcRequestBuilderUtils.isGeneric(field)) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            return MockMvcRequestBuilderUtils.isComplexType((Class)actualTypeArguments[0]);
        }
        return MockMvcRequestBuilderUtils.isComplexType(field.getType());
    }

    private static boolean isGeneric(Field field) {
        return !(field.getGenericType() instanceof Class);
    }

    private static boolean isComplexType(Class<?> type) {
        if (type.getComponentType() != null) {
            return MockMvcRequestBuilderUtils.isComplexType(type.getComponentType());
        }
        return !ClassUtils.isPrimitiveOrWrapper(type) && !String.class.isAssignableFrom(type) && !Date.class.isAssignableFrom(type) && !Temporal.class.isAssignableFrom(type) && type.getSuperclass() != null && !Enum.class.isAssignableFrom(type.getSuperclass());
    }

    private static boolean isIterable(Class fieldClass) {
        return Iterable.class.isAssignableFrom(fieldClass) || Object[].class.isAssignableFrom(fieldClass);
    }

    private static boolean isMap(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    public static class Configuration {
        private final Predicate<Field> fieldPredicate;

        private Configuration(Predicate<Field> fieldPredicate) {
            this.fieldPredicate = fieldPredicate;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private static final Predicate<Field> BASE_PREDICATE = Builder::isNotSynthetic;
            private Predicate<Field> fieldPredicate;
            private boolean includeFinal = true;
            private boolean includeTransient = false;
            private boolean includeStatic = false;

            public Builder fieldPredicate(Predicate<Field> fieldPredicate) {
                this.fieldPredicate = Objects.requireNonNull(fieldPredicate, "fieldPredicate cannot be null");
                return this;
            }

            public Builder includeTransient(boolean includeTransient) {
                this.includeTransient = includeTransient;
                return this;
            }

            public Builder includeFinal(boolean includeFinal) {
                this.includeFinal = includeFinal;
                return this;
            }

            public Builder includeStatic(boolean includeStatic) {
                this.includeStatic = includeStatic;
                return this;
            }

            public Configuration build() {
                Predicate<Field> fieldPredicate;
                Predicate<Field> predicate = fieldPredicate = this.fieldPredicate != null ? BASE_PREDICATE.and(this.fieldPredicate) : BASE_PREDICATE;
                if (!this.includeFinal) {
                    fieldPredicate = fieldPredicate.and(Builder::isNotFinal);
                }
                if (!this.includeTransient) {
                    fieldPredicate = fieldPredicate.and(Builder::isNotTransient);
                }
                if (!this.includeStatic) {
                    fieldPredicate = fieldPredicate.and(Builder::isNotStatic);
                }
                return new Configuration(fieldPredicate);
            }

            private static boolean isNotFinal(Field field) {
                return !Modifier.isFinal(field.getModifiers());
            }

            private static boolean isNotTransient(Field field) {
                return !Modifier.isTransient(field.getModifiers());
            }

            private static boolean isNotStatic(Field field) {
                return !Modifier.isStatic(field.getModifiers());
            }

            private static boolean isNotSynthetic(Field field) {
                return !field.isSynthetic();
            }
        }
    }

    public static class FormRequestPostProcessor
    implements RequestPostProcessor {
        private final Object form;
        private final Configuration config;

        private FormRequestPostProcessor(Object form, Configuration config) {
            this.form = form;
            this.config = config;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            Map<String, String> formFields = MockMvcRequestBuilderUtils.getFormFields(this.form, new TreeMap<String, String>(), "", this.config);
            formFields.forEach((path, value) -> {
                LOGGER.debug("Adding form field ({}={}) to HTTP request parameters", path, value);
                request.addParameter(path, value);
            });
            return request;
        }
    }
}

