/*
 * Decompiled with CFR 0.152.
 */
package io.florianlopes.spring.test.web.servlet.request;

import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MockMvcRequestBuilderUtils {
    private static final PropertyEditorRegistrySupport PROPERTY_EDITOR_REGISTRY = new SimpleTypeConverter();
    private static final Logger LOGGER = LoggerFactory.getLogger(MockMvcRequestBuilderUtils.class);

    private MockMvcRequestBuilderUtils() {
    }

    public static void registerPropertyEditor(Class type, PropertyEditor propertyEditor) {
        PROPERTY_EDITOR_REGISTRY.registerCustomEditor(type, propertyEditor);
    }

    public static FormRequestPostProcessor form(Object form) {
        return new FormRequestPostProcessor(form);
    }

    public static MockHttpServletRequestBuilder postForm(String url, Object form) {
        MockHttpServletRequestBuilder mockHttpServletRequestBuilder = MockMvcRequestBuilders.post((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED);
        return MockMvcRequestBuilderUtils.buildFormFields(form, mockHttpServletRequestBuilder);
    }

    public static MockHttpServletRequestBuilder putForm(String url, Object form) {
        MockHttpServletRequestBuilder mockHttpServletRequestBuilder = MockMvcRequestBuilders.put((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED);
        return MockMvcRequestBuilderUtils.buildFormFields(form, mockHttpServletRequestBuilder);
    }

    private static MockHttpServletRequestBuilder buildFormFields(Object form, MockHttpServletRequestBuilder mockHttpServletRequestBuilder) {
        Map<String, String> formFields = MockMvcRequestBuilderUtils.getFormFields(form, new TreeMap<String, String>(), "");
        formFields.forEach((path, value) -> {
            LOGGER.debug("Adding form field ({}={}) to HTTP request parameters", path, value);
            mockHttpServletRequestBuilder.param(path, new String[]{value});
        });
        return mockHttpServletRequestBuilder;
    }

    private static Map<String, String> getFormFields(Object form, Map<String, String> formFields, String path) {
        ArrayList fields = form != null ? MockMvcRequestBuilderUtils.getAllNonSyntheticFields(form) : new ArrayList();
        for (Field field : fields) {
            Class<?> fieldType = field.getType();
            Object fieldValue = MockMvcRequestBuilderUtils.getFieldValue(form, field);
            if (fieldValue == null) continue;
            if (MockMvcRequestBuilderUtils.isIterable(fieldType)) {
                Iterable<?> iterableObject = MockMvcRequestBuilderUtils.getIterable(fieldValue, fieldType);
                if (iterableObject == null) continue;
                if (MockMvcRequestBuilderUtils.isComplexField(field)) {
                    int i = 0;
                    for (Object object : iterableObject) {
                        String nestedPath = MockMvcRequestBuilderUtils.getPositionedField(path, field, i) + ".";
                        formFields.putAll(MockMvcRequestBuilderUtils.getFormFields(object, formFields, nestedPath));
                        ++i;
                    }
                    continue;
                }
                formFields.putAll(MockMvcRequestBuilderUtils.getCollectionFields(iterableObject, path, field));
                continue;
            }
            if (MockMvcRequestBuilderUtils.isMap(fieldType)) {
                Map<?, ?> map = MockMvcRequestBuilderUtils.getMap(fieldValue, fieldType);
                if (map == null) continue;
                map.forEach((key, value) -> formFields.put(MockMvcRequestBuilderUtils.getPositionedField(path, field, MockMvcRequestBuilderUtils.getStringValue(key)), MockMvcRequestBuilderUtils.getStringValue(value)));
                continue;
            }
            if (!MockMvcRequestBuilderUtils.isComplexField(field) || MockMvcRequestBuilderUtils.hasPropertyEditorFor(fieldType)) {
                formFields.put(path + field.getName(), MockMvcRequestBuilderUtils.getStringValue(fieldValue));
                continue;
            }
            String nestedPath = MockMvcRequestBuilderUtils.getNestedPath(field);
            formFields.putAll(MockMvcRequestBuilderUtils.getFormFields(ReflectionTestUtils.getField((Object)form, (String)field.getName()), formFields, nestedPath));
        }
        return formFields;
    }

    private static List<Field> getAllNonSyntheticFields(Object form) {
        return FieldUtils.getAllFieldsList(form.getClass()).stream().filter(field -> !field.isSynthetic()).collect(Collectors.toList());
    }

    private static Map<?, ?> getMap(Object fieldValue, Class<?> type) {
        return Map.class.isAssignableFrom(type) ? (Map)fieldValue : null;
    }

    private static Iterable<?> getIterable(Object fieldValue, Class<?> type) {
        return Iterable.class.isAssignableFrom(type) ? (Iterable)fieldValue : CollectionUtils.arrayToList((Object)fieldValue);
    }

    private static Map<String, String> getCollectionFields(Iterable<?> iterable, String path, Field field) {
        TreeMap<String, String> fields = new TreeMap<String, String>();
        int i = 0;
        for (Object object : iterable) {
            fields.put(MockMvcRequestBuilderUtils.getPositionedField(path, field, i), MockMvcRequestBuilderUtils.getStringValue(object));
            ++i;
        }
        return fields;
    }

    private static String getPositionedField(String path, Field field, int position) {
        return MockMvcRequestBuilderUtils.getPositionedField(path, field, String.valueOf(position));
    }

    private static String getPositionedField(String path, Field field, String positionOrKey) {
        return String.format("%s%s[%s]", path, field.getName(), positionOrKey);
    }

    private static String getNestedPath(Field field) {
        return field.getName() + ".";
    }

    private static Object getFieldValue(Object form, Field field) {
        return ReflectionTestUtils.getField((Object)form, (String)field.getName());
    }

    private static String getStringValue(Object object) {
        if (object != null) {
            PropertyEditor propertyEditor = MockMvcRequestBuilderUtils.getPropertyEditorFor(object);
            if (propertyEditor != null) {
                propertyEditor.setValue(object);
                return propertyEditor.getAsText();
            }
            return String.valueOf(object);
        }
        return "";
    }

    private static boolean hasPropertyEditorFor(Class<?> type) {
        return PROPERTY_EDITOR_REGISTRY.hasCustomEditorForElement(type, null) || PROPERTY_EDITOR_REGISTRY.getDefaultEditor(type) != null;
    }

    private static PropertyEditor getPropertyEditorFor(Object object) {
        return PROPERTY_EDITOR_REGISTRY.hasCustomEditorForElement(object.getClass(), null) ? PROPERTY_EDITOR_REGISTRY.findCustomEditor(object.getClass(), null) : PROPERTY_EDITOR_REGISTRY.getDefaultEditor(object.getClass());
    }

    private static boolean isComplexField(Field field) {
        if (MockMvcRequestBuilderUtils.isGeneric(field)) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            return MockMvcRequestBuilderUtils.isComplexType((Class)actualTypeArguments[0]);
        }
        return MockMvcRequestBuilderUtils.isComplexType(field.getType());
    }

    private static boolean isGeneric(Field field) {
        return !(field.getGenericType() instanceof Class);
    }

    private static boolean isComplexType(Class<?> type) {
        if (type.getComponentType() != null) {
            return MockMvcRequestBuilderUtils.isComplexType(type.getComponentType());
        }
        return !ClassUtils.isPrimitiveOrWrapper(type) && !String.class.isAssignableFrom(type) && !Date.class.isAssignableFrom(type) && !Temporal.class.isAssignableFrom(type) && type.getSuperclass() != null && !Enum.class.isAssignableFrom(type.getSuperclass());
    }

    private static boolean isIterable(Class fieldClass) {
        return Iterable.class.isAssignableFrom(fieldClass) || Object[].class.isAssignableFrom(fieldClass);
    }

    private static boolean isMap(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    public static class FormRequestPostProcessor
    implements RequestPostProcessor {
        private final Object form;

        private FormRequestPostProcessor(Object form) {
            this.form = form;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            Map<String, String> formFields = MockMvcRequestBuilderUtils.getFormFields(this.form, new TreeMap<String, String>(), "");
            formFields.forEach((path, value) -> {
                LOGGER.debug("Adding form field ({}={}) to HTTP request parameters", path, value);
                request.addParameter(path, value);
            });
            return request;
        }
    }
}

