/*
 * Decompiled with CFR 0.152.
 */
package io.florianlopes.spring.test.web.servlet.request;

import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.http.MediaType;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MockMvcRequestBuilderUtils {
    private static final PropertyEditorRegistrySupport propertyEditorRegistry = new SimpleTypeConverter();
    private static final Log logger = LogFactory.getLog(MockMvcRequestBuilderUtils.class);

    private MockMvcRequestBuilderUtils() {
    }

    public static void registerPropertyEditor(Class type, PropertyEditor propertyEditor) {
        propertyEditorRegistry.registerCustomEditor(type, propertyEditor);
    }

    public static MockHttpServletRequestBuilder postForm(String url, Object form) {
        MockHttpServletRequestBuilder mockHttpServletRequestBuilder = MockMvcRequestBuilders.post((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED);
        Map<String, String> formFields = MockMvcRequestBuilderUtils.getFormFields(form, new TreeMap<String, String>(), "");
        formFields.forEach((path, value) -> {
            logger.debug((Object)String.format("Adding form field (%s=%s) to HTTP request parameters", path, value));
            mockHttpServletRequestBuilder.param(path, new String[]{value});
        });
        return mockHttpServletRequestBuilder;
    }

    private static Map<String, String> getFormFields(Object form, Map<String, String> formFields, String path) {
        List<Object> fields = form != null ? Arrays.asList(FieldUtils.getAllFields(form.getClass())) : new ArrayList();
        for (Field field : fields) {
            Class<?> fieldType = field.getType();
            Object fieldValue = MockMvcRequestBuilderUtils.getFieldValue(form, field);
            if (fieldValue == null) continue;
            if (MockMvcRequestBuilderUtils.isIterable(fieldType)) {
                Iterable<?> iterableObject = MockMvcRequestBuilderUtils.getIterable(fieldValue, fieldType);
                if (iterableObject == null) continue;
                if (MockMvcRequestBuilderUtils.isComplexField(field)) {
                    int i = 0;
                    for (Object object : iterableObject) {
                        String nestedPath = MockMvcRequestBuilderUtils.getPositionedField(path, field, i) + ".";
                        formFields.putAll(MockMvcRequestBuilderUtils.getFormFields(object, formFields, nestedPath));
                        ++i;
                    }
                    continue;
                }
                formFields.putAll(MockMvcRequestBuilderUtils.getCollectionFields(iterableObject, path, field));
                continue;
            }
            if (MockMvcRequestBuilderUtils.isMap(fieldType)) {
                Map<?, ?> map = MockMvcRequestBuilderUtils.getMap(fieldValue, fieldType);
                if (map == null) continue;
                map.forEach((key, value) -> formFields.put(MockMvcRequestBuilderUtils.getPositionedField(path, field, MockMvcRequestBuilderUtils.getStringValue(key)), MockMvcRequestBuilderUtils.getStringValue(value)));
                continue;
            }
            if (!MockMvcRequestBuilderUtils.isComplexField(field) || MockMvcRequestBuilderUtils.hasPropertyEditorFor(fieldType)) {
                formFields.put(path + field.getName(), MockMvcRequestBuilderUtils.getStringValue(fieldValue));
                continue;
            }
            String nestedPath = MockMvcRequestBuilderUtils.getNestedPath(field);
            formFields.putAll(MockMvcRequestBuilderUtils.getFormFields(ReflectionTestUtils.getField((Object)form, (String)field.getName()), formFields, nestedPath));
        }
        return formFields;
    }

    private static Map<?, ?> getMap(Object fieldValue, Class<?> type) {
        return Map.class.isAssignableFrom(type) ? (Map)fieldValue : null;
    }

    private static Iterable<?> getIterable(Object fieldValue, Class<?> type) {
        return Iterable.class.isAssignableFrom(type) ? (Iterable)fieldValue : CollectionUtils.arrayToList((Object)fieldValue);
    }

    private static Map<String, String> getCollectionFields(Iterable<?> iterable, String path, Field field) {
        TreeMap<String, String> fields = new TreeMap<String, String>();
        int i = 0;
        for (Object object : iterable) {
            fields.put(MockMvcRequestBuilderUtils.getPositionedField(path, field, i), MockMvcRequestBuilderUtils.getStringValue(object));
            ++i;
        }
        return fields;
    }

    private static String getPositionedField(String path, Field field, int position) {
        return MockMvcRequestBuilderUtils.getPositionedField(path, field, String.valueOf(position));
    }

    private static String getPositionedField(String path, Field field, String positionOrKey) {
        return String.format("%s%s[%s]", path, field.getName(), positionOrKey);
    }

    private static String getNestedPath(Field field) {
        return field.getName() + ".";
    }

    private static Object getFieldValue(Object form, Field field) {
        return ReflectionTestUtils.getField((Object)form, (String)field.getName());
    }

    private static String getStringValue(Object object) {
        if (object != null) {
            PropertyEditor propertyEditor = MockMvcRequestBuilderUtils.getPropertyEditorFor(object);
            if (propertyEditor != null) {
                propertyEditor.setValue(object);
                return propertyEditor.getAsText();
            }
            return String.valueOf(object);
        }
        return "";
    }

    private static boolean hasPropertyEditorFor(Class<?> type) {
        return propertyEditorRegistry.hasCustomEditorForElement(type, null) || propertyEditorRegistry.getDefaultEditor(type) != null;
    }

    private static PropertyEditor getPropertyEditorFor(Object object) {
        return propertyEditorRegistry.hasCustomEditorForElement(object.getClass(), null) ? propertyEditorRegistry.findCustomEditor(object.getClass(), null) : propertyEditorRegistry.getDefaultEditor(object.getClass());
    }

    private static boolean isComplexField(Field field) {
        if (MockMvcRequestBuilderUtils.isGeneric(field)) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            return MockMvcRequestBuilderUtils.isComplexType((Class)actualTypeArguments[0]);
        }
        return MockMvcRequestBuilderUtils.isComplexType(field.getType());
    }

    private static boolean isGeneric(Field field) {
        return !(field.getGenericType() instanceof Class);
    }

    private static boolean isComplexType(Class<?> type) {
        if (type.getComponentType() != null) {
            return MockMvcRequestBuilderUtils.isComplexType(type.getComponentType());
        }
        return !ClassUtils.isPrimitiveOrWrapper(type) && !String.class.isAssignableFrom(type) && !Date.class.isAssignableFrom(type) && !Temporal.class.isAssignableFrom(type) && type.getSuperclass() != null && !Enum.class.isAssignableFrom(type.getSuperclass());
    }

    private static boolean isIterable(Class fieldClass) {
        return Iterable.class.isAssignableFrom(fieldClass) || Object[].class.isAssignableFrom(fieldClass);
    }

    private static boolean isMap(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }
}

