/*
 * Decompiled with CFR 0.152.
 */
package io.florianlopes.spring.test.web.servlet.request;

import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.http.MediaType;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MockMvcRequestBuilderUtils {
    private static final Map<Class, PropertyEditor> propertyEditors = new HashMap<Class, PropertyEditor>();

    private MockMvcRequestBuilderUtils() {
    }

    public static void registerPropertyEditor(Class type, PropertyEditor propertyEditor) {
        propertyEditors.put(type, propertyEditor);
    }

    public static void unregisterPropertyEditor(Class type) {
        propertyEditors.remove(type);
    }

    public static void unregisterPropertyEditors() {
        propertyEditors.clear();
    }

    public static MockHttpServletRequestBuilder postForm(String url, Object form) {
        MockHttpServletRequestBuilder mockHttpServletRequestBuilder = MockMvcRequestBuilders.post((String)url, (Object[])new Object[0]).characterEncoding("UTF-8").contentType(MediaType.APPLICATION_FORM_URLENCODED);
        Map<String, String> formFields = MockMvcRequestBuilderUtils.getFormFields(form, new TreeMap<String, String>(), "");
        formFields.forEach((x$0, xva$1) -> mockHttpServletRequestBuilder.param(x$0, new String[]{xva$1}));
        return mockHttpServletRequestBuilder;
    }

    private static Map<String, String> getFormFields(Object form, Map<String, String> formFields, String path) {
        List<Object> fields = form != null ? Arrays.asList(FieldUtils.getAllFields(form.getClass())) : new ArrayList();
        for (Field field : fields) {
            if (MockMvcRequestBuilderUtils.isIterable(field.getType())) {
                Iterable<?> iterable = MockMvcRequestBuilderUtils.getIterable(MockMvcRequestBuilderUtils.getFieldValue(form, field), field.getType());
                if (iterable == null) continue;
                if (MockMvcRequestBuilderUtils.isComplexField(field)) {
                    int i = 0;
                    for (Object o : iterable) {
                        String nestedPath = MockMvcRequestBuilderUtils.getPositionedField(path, field, i) + ".";
                        formFields.putAll(MockMvcRequestBuilderUtils.getFormFields(o, formFields, nestedPath));
                        ++i;
                    }
                    continue;
                }
                formFields.putAll(MockMvcRequestBuilderUtils.getCollectionFields(iterable, path, field));
                continue;
            }
            if (MockMvcRequestBuilderUtils.isComplexField(field)) {
                String nestedPath = MockMvcRequestBuilderUtils.getNestedPath(path, field);
                formFields.putAll(MockMvcRequestBuilderUtils.getFormFields(ReflectionTestUtils.getField((Object)form, (String)field.getName()), formFields, nestedPath));
                continue;
            }
            formFields.put(path + field.getName(), MockMvcRequestBuilderUtils.getFieldStringValue(form, field));
        }
        return formFields;
    }

    private static Iterable<?> getIterable(Object fieldValue, Class<?> type) {
        return fieldValue != null ? (Iterable.class.isAssignableFrom(type) ? (Iterable)fieldValue : CollectionUtils.arrayToList((Object)fieldValue)) : null;
    }

    private static Map<String, String> getCollectionFields(Iterable<?> iterable, String path, Field field) {
        TreeMap<String, String> fields = new TreeMap<String, String>();
        int i = 0;
        for (Object object : iterable) {
            fields.put(MockMvcRequestBuilderUtils.getPositionedField(path, field, i), MockMvcRequestBuilderUtils.getStringValue(object));
            ++i;
        }
        return fields;
    }

    private static String getPositionedField(String path, Field field, int position) {
        return path + field.getName() + "[" + position + "]";
    }

    private static String getNestedPath(String path, Field field) {
        return StringUtils.isNotEmpty((CharSequence)path) ? path + field.getName() + "." : field.getName() + ".";
    }

    private static Object getFieldValue(Object form, Field field) {
        return ReflectionTestUtils.getField((Object)form, (String)field.getName());
    }

    private static String getFieldStringValue(Object object, Field field) {
        return MockMvcRequestBuilderUtils.getStringValue(MockMvcRequestBuilderUtils.getFieldValue(object, field));
    }

    private static String getStringValue(Object object) {
        if (object != null) {
            PropertyEditor propertyEditor = MockMvcRequestBuilderUtils.getPropertyEditorFor(object);
            if (propertyEditor != null) {
                propertyEditor.setValue(object);
                return propertyEditor.getAsText();
            }
            return String.valueOf(object);
        }
        return "";
    }

    private static PropertyEditor getPropertyEditorFor(Object object) {
        Optional<Map.Entry> propertyEditorEntry = propertyEditors.entrySet().stream().filter(entry -> ((Class)entry.getKey()).equals(object.getClass())).findFirst();
        return propertyEditorEntry.isPresent() ? (PropertyEditor)propertyEditorEntry.get().getValue() : null;
    }

    private static boolean isComplexField(Field field) {
        if (MockMvcRequestBuilderUtils.isGeneric(field)) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            return MockMvcRequestBuilderUtils.isComplexType((Class)actualTypeArguments[0]);
        }
        return MockMvcRequestBuilderUtils.isComplexType(field.getType());
    }

    private static boolean isGeneric(Field field) {
        return !(field.getGenericType() instanceof Class);
    }

    private static boolean isComplexType(Class<?> type) {
        if (type.getComponentType() != null) {
            return MockMvcRequestBuilderUtils.isComplexType(type.getComponentType());
        }
        return !ClassUtils.isPrimitiveOrWrapper(type) && !String.class.isAssignableFrom(type) && !Date.class.isAssignableFrom(type) && !Temporal.class.isAssignableFrom(type) && !Enum.class.isAssignableFrom(type.getSuperclass());
    }

    private static boolean isIterable(Class fieldClass) {
        return Iterable.class.isAssignableFrom(fieldClass) || Object[].class.isAssignableFrom(fieldClass);
    }
}

