/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableMap;
import com.wordnik.swagger.jaxrs.config.BeanConfig;
import com.wordnik.swagger.jaxrs.listing.ApiListingResource;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewBundle;
import io.federecio.dropwizard.swagger.ConfigurationHelper;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import io.federecio.dropwizard.swagger.SwaggerResource;

public abstract class SwaggerBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.addBundle((ConfiguredBundle)new ViewBundle<Configuration>(){

            public ImmutableMap<String, ImmutableMap<String, String>> getViewConfiguration(Configuration configuration) {
                return ImmutableMap.of();
            }
        });
    }

    public void run(T configuration, Environment environment) throws Exception {
        SwaggerBundleConfiguration swaggerBundleConfiguration = this.getSwaggerBundleConfiguration(configuration);
        if (swaggerBundleConfiguration == null) {
            throw new IllegalStateException("You need to provide an instance of SwaggerBundleConfiguration");
        }
        ConfigurationHelper configurationHelper = new ConfigurationHelper((Configuration)configuration, swaggerBundleConfiguration);
        new AssetsBundle("/swagger-static", configurationHelper.getSwaggerUriPath(), null, "swagger-assets").run(environment);
        environment.jersey().register((Object)new SwaggerResource(configurationHelper.getUrlPattern()));
        environment.getObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.setUpSwagger(swaggerBundleConfiguration, configurationHelper.getUrlPattern());
        environment.jersey().register((Object)new ApiListingResource());
    }

    protected abstract SwaggerBundleConfiguration getSwaggerBundleConfiguration(T var1);

    private void setUpSwagger(SwaggerBundleConfiguration swaggerBundleConfiguration, String urlPattern) {
        BeanConfig config = new BeanConfig();
        if (swaggerBundleConfiguration.getTitle() != null) {
            config.setTitle(swaggerBundleConfiguration.getTitle());
        }
        if (swaggerBundleConfiguration.getVersion() != null) {
            config.setVersion(swaggerBundleConfiguration.getVersion());
        }
        if (swaggerBundleConfiguration.getDescription() != null) {
            config.setDescription(swaggerBundleConfiguration.getDescription());
        }
        if (swaggerBundleConfiguration.getContact() != null) {
            config.setContact(swaggerBundleConfiguration.getContact());
        }
        if (swaggerBundleConfiguration.getLicense() != null) {
            config.setLicense(swaggerBundleConfiguration.getLicense());
        }
        if (swaggerBundleConfiguration.getLicenseUrl() != null) {
            config.setLicenseUrl(swaggerBundleConfiguration.getLicenseUrl());
        }
        if (swaggerBundleConfiguration.getTermsOfServiceUrl() != null) {
            config.setTermsOfServiceUrl(swaggerBundleConfiguration.getTermsOfServiceUrl());
        }
        config.setBasePath(urlPattern);
        if (swaggerBundleConfiguration.getResourcePackage() == null) {
            throw new IllegalStateException("Resource package needs to be specified for Swagger to correctly detect annotated resources");
        }
        config.setResourcePackage(swaggerBundleConfiguration.getResourcePackage());
        config.setScan(true);
    }
}

