/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import io.dropwizard.Bundle;
import io.dropwizard.Configuration;
import io.dropwizard.server.ServerFactory;
import io.dropwizard.server.SimpleServerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewBundle;
import io.federecio.dropwizard.swagger.SwaggerBundle;
import io.federecio.dropwizard.swagger.SwaggerResource;
import java.io.IOException;

public class SwaggerDropwizard {
    public void onInitialize(Bootstrap<?> bootstrap) {
        bootstrap.addBundle((Bundle)new SwaggerBundle());
        bootstrap.addBundle((Bundle)new ViewBundle());
    }

    public void onRun(Configuration configuration, Environment environment) throws IOException {
        this._onRun(configuration, environment);
        SwaggerBundle.configure(configuration);
    }

    public void onRun(Configuration configuration, Environment environment, String host) {
        this._onRun(configuration, environment);
        SwaggerBundle.configure(configuration, host);
    }

    private void _onRun(Configuration configuration, Environment environment) {
        ServerFactory serverFactory = configuration.getServerFactory();
        String applicationContextPath = serverFactory instanceof SimpleServerFactory ? ((SimpleServerFactory)serverFactory).getApplicationContextPath() : "/";
        environment.jersey().register((Object)new SwaggerResource(applicationContextPath));
    }
}

