/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import com.wordnik.swagger.config.ConfigFactory;
import com.wordnik.swagger.config.Scanner;
import com.wordnik.swagger.config.ScannerFactory;
import com.wordnik.swagger.config.SwaggerConfig;
import com.wordnik.swagger.jaxrs.config.DefaultJaxrsScanner;
import com.wordnik.swagger.jaxrs.listing.ApiDeclarationProvider;
import com.wordnik.swagger.jaxrs.listing.ApiListingResourceJSON;
import com.wordnik.swagger.jaxrs.listing.ResourceListingProvider;
import com.wordnik.swagger.jaxrs.reader.DefaultJaxrsApiReader;
import com.wordnik.swagger.reader.ClassReader;
import com.wordnik.swagger.reader.ClassReaders;
import io.dropwizard.Configuration;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.jetty.ConnectorFactory;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.jetty.HttpsConnectorFactory;
import io.dropwizard.server.DefaultServerFactory;
import io.dropwizard.server.ServerFactory;
import io.dropwizard.server.SimpleServerFactory;
import io.dropwizard.setup.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerBundle
extends AssetsBundle {
    public static final String PATH = "/swagger-static";
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerBundle.class);
    private static final String DEFAULT_SWAGGER_HOST = "localhost";

    public SwaggerBundle() {
        super(PATH);
    }

    public static void configure(Configuration configuration) throws IOException {
        String host = SwaggerBundle.determineHost();
        SwaggerBundle.configure(configuration, host);
    }

    public static void configure(Configuration configuration, String host) {
        SwaggerConfig config = ConfigFactory.config();
        String swaggerBasePath = SwaggerBundle.getSwaggerBasePath(configuration, host);
        config.setBasePath(swaggerBasePath);
        config.setApiPath(swaggerBasePath);
    }

    private static String getSwaggerBasePath(Configuration configuration, String host) {
        String protocol;
        HttpConnectorFactory httpConnectorFactory;
        String applicationContextPath;
        block8: {
            ServerFactory serverFactory;
            block6: {
                ConnectorFactory cf;
                block7: {
                    applicationContextPath = "/";
                    serverFactory = configuration.getServerFactory();
                    httpConnectorFactory = null;
                    if (!(serverFactory instanceof SimpleServerFactory)) break block6;
                    applicationContextPath = ((SimpleServerFactory)serverFactory).getApplicationContextPath();
                    cf = ((SimpleServerFactory)serverFactory).getConnector();
                    if (!(cf instanceof HttpsConnectorFactory)) break block7;
                    httpConnectorFactory = (HttpConnectorFactory)cf;
                    break block8;
                }
                if (!(cf instanceof HttpConnectorFactory)) break block8;
                httpConnectorFactory = (HttpConnectorFactory)cf;
                break block8;
            }
            if (serverFactory instanceof DefaultServerFactory) {
                List applicationConnectors = ((DefaultServerFactory)serverFactory).getApplicationConnectors();
                for (ConnectorFactory connectorFactory : applicationConnectors) {
                    if (!(connectorFactory instanceof HttpsConnectorFactory)) continue;
                    httpConnectorFactory = (HttpConnectorFactory)connectorFactory;
                }
                if (httpConnectorFactory == null) {
                    for (ConnectorFactory connectorFactory : applicationConnectors) {
                        if (!(connectorFactory instanceof HttpConnectorFactory)) continue;
                        httpConnectorFactory = (HttpConnectorFactory)connectorFactory;
                    }
                }
            }
        }
        if (httpConnectorFactory == null) {
            throw new IllegalStateException("Could not get HttpConnectorFactory");
        }
        String string = protocol = httpConnectorFactory instanceof HttpsConnectorFactory ? "https" : "http";
        if (!"/".equals(applicationContextPath)) {
            return String.format("%s://%s:%s%s", protocol, host, httpConnectorFactory.getPort(), applicationContextPath);
        }
        return String.format("%s://%s:%s", protocol, host, httpConnectorFactory.getPort());
    }

    private static String getHostForSwagger() {
        String swaggerHost = null;
        try {
            swaggerHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to determine host for swagger");
        }
        if (swaggerHost == null) {
            swaggerHost = DEFAULT_SWAGGER_HOST;
        }
        LOGGER.info("Setting host for swagger to {}", (Object)swaggerHost);
        return swaggerHost;
    }

    private static String determineHost() throws IOException {
        String host;
        if (!new File("/var/lib/cloud/").exists()) {
            LOGGER.info("/var/lib/cloud does not exist, assuming that we are running locally");
            host = SwaggerBundle.getHostForSwagger();
        } else {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL("http://169.254.169.254/latest/meta-data/public-hostname/").openConnection();
            urlConnection.setRequestMethod("GET");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                host = reader.readLine();
            }
        }
        return host;
    }

    public void run(Environment environment) {
        environment.jersey().register((Object)new ApiListingResourceJSON());
        environment.jersey().register((Object)new ApiDeclarationProvider());
        environment.jersey().register((Object)new ResourceListingProvider());
        ScannerFactory.setScanner((Scanner)new DefaultJaxrsScanner());
        ClassReaders.setReader((ClassReader)new DefaultJaxrsApiReader());
        super.run(environment);
    }
}

