/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.junitrunner;

import io.dropwizard.Application;
import io.federecio.dropwizard.junitrunner.DropwizardJunitRunnerException;
import io.federecio.dropwizard.junitrunner.DropwizardTestConfig;
import java.lang.annotation.Annotation;
import java.net.URL;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class DropwizardJunitRunner
extends BlockJUnit4ClassRunner {
    private Application<?> application;

    public DropwizardJunitRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected Statement classBlock(RunNotifier notifier) {
        DropwizardTestConfig dropwizardTestConfig = this.getTestConfigOrFail();
        URL resource = this.getYamlConfigFileOrFail(dropwizardTestConfig);
        try {
            this.application = dropwizardTestConfig.applicationClass().newInstance();
            this.application.run(new String[]{"server", resource.getFile()});
        }
        catch (IllegalAccessException e) {
            throw new DropwizardJunitRunnerException("Could not access class or class' constructor on " + dropwizardTestConfig.applicationClass(), e);
        }
        catch (InstantiationException e) {
            throw new DropwizardJunitRunnerException("Could not instantiate class " + dropwizardTestConfig.applicationClass(), e);
        }
        catch (Exception e) {
            throw new DropwizardJunitRunnerException(e);
        }
        return super.classBlock(notifier);
    }

    protected Application<?> getApplication() {
        return this.application;
    }

    private DropwizardTestConfig getTestConfigOrFail() {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.getTestClass().getAnnotations()) {
            if (!annotation.annotationType().equals(DropwizardTestConfig.class)) continue;
            return (DropwizardTestConfig)annotation;
        }
        throw new DropwizardJunitRunnerException("Test class needs to be annotated with @" + DropwizardTestConfig.class.getSimpleName());
    }

    private URL getYamlConfigFileOrFail(DropwizardTestConfig dropwizardTestConfig) {
        URL resource = ((Object)((Object)this)).getClass().getResource(dropwizardTestConfig.yamlFile());
        if (resource == null) {
            throw new DropwizardJunitRunnerException("Yaml file not found");
        }
        return resource;
    }
}

