/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin.env;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.s3.AmazonS3Client;
import com.tvarit.plugin.AbstractTvaritMojo;
import com.tvarit.plugin.TemplateUrlMaker;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public final class TvaritEnvironment {
    private MavenProject mavenProject;
    private Log logger;
    private TemplateUrlMaker templateUrlMaker;
    private static TvaritEnvironment instance;
    private AmazonCloudFormationClient amazonCloudFormationClient;
    private AbstractTvaritMojo mojo;
    private AmazonS3Client amazonS3Client;

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public Log getLogger() {
        return this.logger;
    }

    public TemplateUrlMaker getTemplateUrlMaker() {
        return this.templateUrlMaker;
    }

    public static synchronized TvaritEnvironment init(AbstractTvaritMojo mojo) {
        if (instance != null) {
            throw new RuntimeException("already initialized");
        }
        instance = new TvaritEnvironment();
        TvaritEnvironment.instance.mavenProject = mojo.getPluginContext().getOrDefault("project", null);
        TvaritEnvironment.instance.logger = mojo.getLog();
        String awsAuthProfile = mojo.getAwsAuthProfile();
        Object awsCredentialsProvider = awsAuthProfile != null ? new ProfileCredentialsProvider(awsAuthProfile) : new DefaultAWSCredentialsProviderChain();
        TvaritEnvironment.instance.amazonCloudFormationClient = new AmazonCloudFormationClient((AWSCredentialsProvider)awsCredentialsProvider);
        TvaritEnvironment.instance.amazonS3Client = new AmazonS3Client((AWSCredentialsProvider)awsCredentialsProvider);
        TvaritEnvironment.instance.templateUrlMaker = new TemplateUrlMaker();
        TvaritEnvironment.instance.mojo = mojo;
        return instance;
    }

    public static TvaritEnvironment getInstance() {
        return instance;
    }

    public AmazonCloudFormationClient getAmazonCloudFormationClient() {
        return this.amazonCloudFormationClient;
    }

    public <T extends AbstractTvaritMojo> T getMojo() {
        return (T)((Object)this.mojo);
    }

    public String getProjectName() {
        return this.mavenProject.getGroupId() + "-" + this.mavenProject.getArtifactId();
    }

    public AmazonS3Client getAmazonS3Client() {
        return this.amazonS3Client;
    }

    public String getArtifactBucketName() {
        return ((AbstractTvaritMojo)((Object)this.getMojo())).getArtifactBucketName() == null ? "tvarit-" + this.getProjectName() : ((AbstractTvaritMojo)((Object)this.getMojo())).getArtifactBucketName();
    }

    public String getProjectNameCapitalized() {
        String groupId = this.mavenProject.getGroupId();
        String groupIdCapitalized = groupId.substring(0, 1).toUpperCase() + groupId.substring(1, groupId.length());
        String artifactId = this.mavenProject.getArtifactId();
        String artifactIdCapitalized = artifactId.substring(0, 1).toUpperCase() + artifactId.substring(1, groupId.length());
        return groupIdCapitalized + artifactIdCapitalized;
    }
}

