/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin.base;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.tvarit.plugin.MakeBaseInfrastructureMojo;
import com.tvarit.plugin.TemplateUrlMaker;
import com.tvarit.plugin.env.TvaritEnvironment;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class MakeBaseInfrastructureParameterMaker {
    private static final String TVARIT_BUCKET_NAME = "tvarit";

    MakeBaseInfrastructureParameterMaker() {
    }

    List<Parameter> make() {
        String bastionHostTemplateUrl;
        String tvaritArtifactBucketTemplateUrl;
        String routerTemplateUrl;
        String networkTemplateUrl;
        String deployerLambdaTemplateUrl;
        String iamTemplateUrl;
        String snsTopicsUrl;
        String projectName = TvaritEnvironment.getInstance().getProjectName();
        String artifactId = TvaritEnvironment.getInstance().getMavenProject().getArtifactId();
        String projectVersion = TvaritEnvironment.getInstance().getMavenProject().getVersion();
        String artifactBucketName = TvaritEnvironment.getInstance().getArtifactBucketName();
        String availabilityZones = ((MakeBaseInfrastructureMojo)((Object)TvaritEnvironment.getInstance().getMojo())).getAvailabilityZones();
        Parameter bucketNameParm = new Parameter().withParameterKey("ArtifactBucketNameParm").withParameterValue(artifactBucketName);
        Parameter projectNameParm = new Parameter().withParameterKey("ProjectNameParm").withParameterValue(projectName);
        Parameter availabilityZonesParm = new Parameter().withParameterKey("AvailabilityZones").withParameterValue(availabilityZones);
        Parameter elbHealthCheckAbsoluteUrlParm = new Parameter().withParameterKey("ElbHealthCheckUrl").withParameterValue("/to_be_fixed.html");
        Parameter sshKeyParm = new Parameter().withParameterKey("SshKeyPairName").withParameterValue(((MakeBaseInfrastructureMojo)((Object)TvaritEnvironment.getInstance().getMojo())).getSshKeyPairName());
        String allDeployerLambdaFunctionCodeS3Key = "default/io.tvarit/tvarit-maven-plugin/0.1.2-SNAPSHOT/lambda/tvarit-lambda.zip";
        try {
            snsTopicsUrl = new TemplateUrlMaker().makeUrl("base/messaging.template").toString();
            iamTemplateUrl = new TemplateUrlMaker().makeUrl("base/iam.template").toString();
            deployerLambdaTemplateUrl = new TemplateUrlMaker().makeUrl("base/deployer_lambda.template").toString();
            networkTemplateUrl = new TemplateUrlMaker().makeUrl("base/network.template").toString();
            routerTemplateUrl = new TemplateUrlMaker().makeUrl("base/router.template").toString();
            tvaritArtifactBucketTemplateUrl = new TemplateUrlMaker().makeUrl("base/artifact_bucket.template").toString();
            bastionHostTemplateUrl = new TemplateUrlMaker().makeUrl("base/bastion.template").toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        Parameter routerTemplateUrlParm = new Parameter().withParameterKey("NetworkTemplateUrl").withParameterValue(networkTemplateUrl);
        Parameter networkTemplateUrlParm = new Parameter().withParameterKey("RouterTemplateUrl").withParameterValue(routerTemplateUrl);
        Parameter iamTemplateUrlParm = new Parameter().withParameterKey("IamTemplateUrl").withParameterValue(iamTemplateUrl);
        Parameter bastionHostTemplateUrlParam = new Parameter().withParameterKey("BastionHostTemplateUrlParam").withParameterValue(bastionHostTemplateUrl);
        Parameter deployerLambdaTemplateUrlParm = new Parameter().withParameterKey("DeployerLambdaTemplateUrl").withParameterValue(deployerLambdaTemplateUrl);
        Parameter tvaritArtifactBucketS3BucketParam = new Parameter().withParameterKey("TvaritArtifactBucketTemplateUrl").withParameterValue(tvaritArtifactBucketTemplateUrl);
        Parameter deployerLambdaFunctionCodeS3BucketParam = new Parameter().withParameterKey("DeployerLambdaFunctionCodeS3BucketParam").withParameterValue(TVARIT_BUCKET_NAME);
        Parameter deployerLambdaFunctionCodeS3KeyParam = new Parameter().withParameterKey("DeployerLambdaFunctionCodeS3KeyParam").withParameterValue(allDeployerLambdaFunctionCodeS3Key);
        Parameter snsTopicsUrlParam = new Parameter().withParameterKey("MessagingTemplateUrl").withParameterValue(snsTopicsUrl);
        ArrayList<Parameter> listOfParms = new ArrayList<Parameter>();
        listOfParms.add(bucketNameParm);
        listOfParms.add(projectNameParm);
        listOfParms.add(availabilityZonesParm);
        listOfParms.add(routerTemplateUrlParm);
        listOfParms.add(networkTemplateUrlParm);
        listOfParms.add(elbHealthCheckAbsoluteUrlParm);
        listOfParms.add(sshKeyParm);
        listOfParms.add(bastionHostTemplateUrlParam);
        listOfParms.add(iamTemplateUrlParm);
        listOfParms.add(deployerLambdaTemplateUrlParm);
        listOfParms.add(deployerLambdaFunctionCodeS3KeyParam);
        listOfParms.add(deployerLambdaFunctionCodeS3BucketParam);
        listOfParms.add(tvaritArtifactBucketS3BucketParam);
        listOfParms.add(snsTopicsUrlParam);
        List stringifiedListOfParms = listOfParms.stream().map(parameter -> parameter.getParameterKey() + " : " + parameter.getParameterValue()).collect(Collectors.toList());
        TvaritEnvironment.getInstance().getLogger().info((CharSequence)("Parameters for main template are: \n\t" + String.join((CharSequence)"\n\t", stringifiedListOfParms)));
        return listOfParms;
    }
}

