/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin.app;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.tvarit.plugin.TemplateUrlMaker;
import com.tvarit.plugin.app.AppDeployerMojo;
import com.tvarit.plugin.env.TvaritEnvironment;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;

class DeployPutRequestMaker {
    DeployPutRequestMaker() {
    }

    PutObjectRequest makePutRequest() throws MojoExecutionException {
        URL url;
        TvaritEnvironment tvaritEnvironment = TvaritEnvironment.getInstance();
        ((AppDeployerMojo)((Object)tvaritEnvironment.getMojo())).getArtifactBucketName();
        File warFile = tvaritEnvironment.getMavenProject().getArtifact().getFile();
        String projectArtifactId = tvaritEnvironment.getMavenProject().getArtifactId();
        String projectVersion = tvaritEnvironment.getMavenProject().getVersion();
        String projectGroupId = tvaritEnvironment.getMavenProject().getGroupId();
        String key = "deployables/" + projectGroupId + "/" + projectArtifactId + "/" + projectVersion + "/" + warFile.getName();
        String bucketName = tvaritEnvironment.getArtifactBucketName();
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, warFile);
        ObjectMetadata metadata = new ObjectMetadata();
        HashMap<String, String> userMetadata = new HashMap<String, String>();
        userMetadata.put("project_name", tvaritEnvironment.getProjectName());
        userMetadata.put("health_check_url", ((AppDeployerMojo)((Object)tvaritEnvironment.getMojo())).getHealthCheckUrl());
        userMetadata.put("private_key_name", ((AppDeployerMojo)((Object)tvaritEnvironment.getMojo())).getSshKeyName());
        userMetadata.put("db-version", ((AppDeployerMojo)((Object)tvaritEnvironment.getMojo())).getDbVersion());
        userMetadata.put("group-id", tvaritEnvironment.getMavenProject().getGroupId());
        userMetadata.put("artifact-id", tvaritEnvironment.getMavenProject().getArtifactId());
        userMetadata.put("version", tvaritEnvironment.getMavenProject().getVersion());
        userMetadata.put("app_fqdn", ((AppDeployerMojo)((Object)tvaritEnvironment.getMojo())).getAppFqdn());
        userMetadata.put("db-name", ((AppDeployerMojo)((Object)tvaritEnvironment.getMojo())).getDbName());
        userMetadata.put("db-username", ((AppDeployerMojo)((Object)tvaritEnvironment.getMojo())).getDbUsername());
        userMetadata.put("db-password", ((AppDeployerMojo)((Object)tvaritEnvironment.getMojo())).getDbPassword());
        String contextConfigUrl = ((AppDeployerMojo)((Object)tvaritEnvironment.getMojo())).getContextConfigUrl();
        try {
            url = new TemplateUrlMaker().makeUrl(contextConfigUrl);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("failed", (Exception)e);
        }
        userMetadata.put("context_config_url", url.toString());
        String contextRoot = ((AppDeployerMojo)((Object)tvaritEnvironment.getMojo())).getContextRoot();
        userMetadata.put("context_root", contextRoot.equals("/") ? "ROOT" : contextRoot);
        metadata.setUserMetadata(userMetadata);
        putObjectRequest.withMetadata(metadata);
        return putObjectRequest;
    }
}

