/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin.app;

import com.tvarit.plugin.AbstractTvaritMojo;
import com.tvarit.plugin.app.AppDeployerDelegate;
import com.tvarit.plugin.env.TvaritEnvironment;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="deploy-app")
public class AppDeployerMojo
extends AbstractTvaritMojo {
    @Parameter(name="ssh-key-name")
    private String sshKeyName;
    @Parameter(name="db-version")
    private String dbVersion;
    @Parameter(name="health-check-url")
    private String healthCheckUrl;
    @Parameter(name="context-config-url", defaultValue="app/web_app.xml", required=false)
    private String contextConfigUrl;
    @Parameter(name="context-root", defaultValue="/", required=false)
    private String contextRoot;
    @Parameter(name="app-fqdn")
    private String appFqdn;
    @Parameter(name="db-name")
    private String dbName;
    @Parameter(name="db-username", defaultValue="fastup")
    private String dbUsername;
    @Parameter(name="db-password", defaultValue="fastup123")
    private String dbPassword;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        new AppDeployerDelegate().deploy();
    }

    public String getSshKeyName() {
        return this.sshKeyName;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    public String getContextConfigUrl() {
        return this.contextConfigUrl;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getAppFqdn() {
        return this.appFqdn;
    }

    public String getDbName() {
        if (this.dbName == null || this.dbName.length() == 0) {
            TvaritEnvironment environment = TvaritEnvironment.getInstance();
            this.dbName = environment.getProjectNameCapitalized() + "Db";
        }
        return this.dbName;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }
}

