/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.tvarit.plugin.IsThisAnUpdate;
import com.tvarit.plugin.TemplateUrlMaker;
import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="deploy-tomcat-ui-app")
public class TvaritTomcatDeployerMojo
extends AbstractMojo {
    @Parameter(required=true, readonly=true, property="myAccessKey")
    private String accessKey;
    @Parameter(required=true, readonly=true, property="mySecretKey")
    private String secretKey;
    @Parameter(required=true)
    private String bucketName;
    @Parameter(required=true)
    private String projectName;
    @Parameter
    private String templateUrl;
    @Parameter(required=true)
    private String sshKeyName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        AmazonEC2Client ec2Client = new AmazonEC2Client((AWSCredentials)awsCredentials);
        AmazonAutoScalingClient autoScalingClient = new AmazonAutoScalingClient((AWSCredentials)awsCredentials);
        MavenProject project = this.getPluginContext().getOrDefault("project", null);
        String projectGroupId = project.getGroupId();
        String projectArtifactId = project.getArtifactId();
        String projectVersion = project.getVersion();
        new IsThisAnUpdate(autoScalingClient).find(projectGroupId, projectArtifactId, projectVersion).perform();
        if (this.templateUrl == null) {
            try {
                this.templateUrl = new TemplateUrlMaker().makeUrl(project, "newinstance.template").toString();
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Could not create default url for templates. Please open an issue on github.", (Exception)e);
            }
        }
        AmazonS3Client s3Client = new AmazonS3Client((AWSCredentials)awsCredentials);
        File warFile = project.getArtifact().getFile();
        String key = "deployables/" + projectGroupId + "/" + projectArtifactId + "/" + projectVersion + "/" + warFile.getName();
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, key, warFile);
        ObjectMetadata metadata = new ObjectMetadata();
        HashMap<String, String> userMetadata = new HashMap<String, String>();
        userMetadata.put("project_name", this.projectName);
        userMetadata.put("stack_template_url", this.templateUrl);
        userMetadata.put("private_key_name", this.sshKeyName);
        metadata.setUserMetadata(userMetadata);
        putObjectRequest.withMetadata(metadata);
        PutObjectResult putObjectResult = s3Client.putObject(putObjectRequest);
    }
}

