/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin;

import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.Filter;
import org.apache.maven.project.MavenProject;

public class SubnetFinder {
    public void find(MavenProject project, AmazonEC2Client amazonEC2Client, String projectName, StringBuilder publicSubnetIdBuilder, StringBuilder publicSubnetAzsBuilder, String subnetType) {
        DescribeSubnetsRequest describeAppSubnetsRequest = new DescribeSubnetsRequest();
        Filter subnetFilter = new Filter().withName("tag-key").withValues(new String[]{projectName + ":" + subnetType});
        describeAppSubnetsRequest.withFilters(new Filter[]{subnetFilter});
        DescribeSubnetsResult describeSubnetsResult = amazonEC2Client.describeSubnets(describeAppSubnetsRequest);
        describeSubnetsResult.getSubnets().stream().forEach(eachSubnet -> {
            publicSubnetAzsBuilder.append(eachSubnet.getAvailabilityZone()).append(",");
            publicSubnetIdBuilder.append(eachSubnet.getSubnetId()).append(",");
        });
        publicSubnetIdBuilder.deleteCharAt(publicSubnetIdBuilder.length() - 1);
        publicSubnetAzsBuilder.deleteCharAt(publicSubnetAzsBuilder.length() - 1);
    }
}

