/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin;

import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.StackStatus;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class StackMaker {
    public Stack makeStack(CreateStackRequest createStackRequest, AmazonCloudFormationClient amazonCloudFormationClient, Log log) throws MojoFailureException {
        CreateStackResult createStackResult = amazonCloudFormationClient.createStack(createStackRequest);
        String stackName = createStackRequest.getStackName();
        DescribeStacksResult describeStacksResult = amazonCloudFormationClient.describeStacks(new DescribeStacksRequest().withStackName(stackName));
        while (((Stack)describeStacksResult.getStacks().get(0)).getStackStatus().equals(StackStatus.CREATE_IN_PROGRESS.toString())) {
            try {
                log.info((CharSequence)"Awaiting stack create completion!");
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error((Throwable)e);
                throw new RuntimeException(e);
            }
            describeStacksResult = amazonCloudFormationClient.describeStacks(new DescribeStacksRequest().withStackName(stackName));
        }
        Stack stack = (Stack)describeStacksResult.getStacks().get(0);
        String stackStatus = stack.getStackStatus();
        if (!stackStatus.equals(StackStatus.CREATE_COMPLETE.toString())) {
            throw new MojoFailureException("Could not create infrastructure. Stack Status is: " + stackStatus + ". Please review details on the AWS console and open a new github issue on https://github.com/sdole/tvarit-maven/issues/new that is needed.");
        }
        return stack;
    }
}

