/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin;

import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.Filter;
import com.amazonaws.services.s3.model.FilterRule;
import com.amazonaws.services.s3.model.LambdaConfiguration;
import com.amazonaws.services.s3.model.S3KeyFilter;
import com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

class S3WarUploadEventToInvokeLambdaMaker {
    S3WarUploadEventToInvokeLambdaMaker() {
    }

    void make(AmazonS3Client amazonS3Client, String bucketName, Stack stack) {
        List outputs = stack.getOutputs();
        String lambdaFunctionArn = outputs.stream().filter(output -> output.getOutputKey().equals("LambdaFunctionArn")).findFirst().get().getOutputValue();
        BucketNotificationConfiguration notificationConfiguration = new BucketNotificationConfiguration();
        HashMap<String, LambdaConfiguration> configurations = new HashMap<String, LambdaConfiguration>();
        LambdaConfiguration lambdaConfiguration = new LambdaConfiguration(lambdaFunctionArn, new String[0]);
        HashSet<String> events = new HashSet<String>();
        events.add("s3:ObjectCreated:*");
        lambdaConfiguration.setEvents(events);
        Filter notificationFilter = new Filter();
        S3KeyFilter s3KeyFilter = new S3KeyFilter();
        notificationFilter.withS3KeyFilter(s3KeyFilter);
        s3KeyFilter.withFilterRules(new FilterRule[]{new FilterRule().withName("suffix").withValue(".war"), new FilterRule().withName("prefix").withValue("deployables")});
        lambdaConfiguration.setFilter(notificationFilter);
        configurations.put("warUploaded", lambdaConfiguration);
        notificationConfiguration.setConfigurations(configurations);
        SetBucketNotificationConfigurationRequest setBucketNotificationConfigurationRequest = new SetBucketNotificationConfigurationRequest(bucketName, notificationConfiguration);
        amazonS3Client.setBucketNotificationConfiguration(setBucketNotificationConfigurationRequest);
    }
}

