/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin;

import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.Output;
import com.amazonaws.services.cloudformation.model.Stack;
import java.util.stream.Collectors;

public class RolesFinder {
    private final DescribeStacksResult describeStacksResult;

    public RolesFinder(String projectName, AmazonCloudFormationClient amazonCloudFormationClient) {
        DescribeStacksRequest describeStacksRequest = new DescribeStacksRequest();
        describeStacksRequest.withStackName(projectName + "-infra");
        this.describeStacksResult = amazonCloudFormationClient.describeStacks(describeStacksRequest);
    }

    public String findRoleArn() {
        return ((Output)((Stack)this.describeStacksResult.getStacks().get(0)).getOutputs().stream().filter(output -> "TvaritRole".equals(output.getOutputKey())).collect(Collectors.toList()).get(0)).getOutputValue();
    }

    public String findInstanceProfileArn() {
        return ((Output)((Stack)this.describeStacksResult.getStacks().get(0)).getOutputs().stream().filter(output -> "TvaritInstanceProfile".equals(output.getOutputKey())).collect(Collectors.toList()).get(0)).getOutputValue();
    }
}

