/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.s3.AmazonS3Client;
import com.tvarit.plugin.AsgParameterMaker;
import com.tvarit.plugin.LambdaS3BucketKeyMaker;
import com.tvarit.plugin.S3WarUploadEventToInvokeLambdaMaker;
import com.tvarit.plugin.StackMaker;
import com.tvarit.plugin.TemplateUrlMaker;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="setup-autoscaling")
public class AutoScalingMojo
extends AbstractMojo {
    @Parameter(required=true, readonly=true, property="mySecretKey")
    private String secretKey;
    @Parameter(required=true, readonly=true, property="myAccessKey")
    private String accessKey;
    @Parameter
    private String templateUrl;
    @Parameter(required=true)
    private String projectName;
    @Parameter(required=true)
    private String bucketName;
    @Parameter
    private String lambdaCodeS3Key;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Starting " + ((Object)((Object)this)).getClass().getSimpleName() + " execution "));
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        AmazonS3Client amazonS3Client = new AmazonS3Client((AWSCredentials)awsCredentials);
        MavenProject project = this.getPluginContext().getOrDefault("project", null);
        String lambdaCodeS3Bucket = this.bucketName;
        if (this.lambdaCodeS3Key == null) {
            this.lambdaCodeS3Key = new LambdaS3BucketKeyMaker().makeKey(project);
            lambdaCodeS3Bucket = "tvarit";
        }
        AmazonCloudFormationClient amazonCloudFormationClient = new AmazonCloudFormationClient((AWSCredentials)awsCredentials);
        AmazonEC2Client amazonEC2Client = new AmazonEC2Client((AWSCredentials)awsCredentials);
        List<com.amazonaws.services.cloudformation.model.Parameter> allParams = new AsgParameterMaker().make(amazonEC2Client, amazonCloudFormationClient, project, this.projectName, this.lambdaCodeS3Key, lambdaCodeS3Bucket);
        String stackName = this.projectName + "-asg";
        if (this.templateUrl == null) {
            try {
                this.templateUrl = new TemplateUrlMaker().makeUrl(project, "autoscaling.template").toString();
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Could not create default url for templates. Please open an issue on github.", (Exception)e);
            }
        }
        CreateStackRequest createStackRequest = new CreateStackRequest().withCapabilities(new Capability[]{Capability.CAPABILITY_IAM}).withStackName(stackName).withParameters(allParams).withTemplateURL(this.templateUrl);
        Stack stack = new StackMaker().makeStack(createStackRequest, amazonCloudFormationClient, this.getLog());
        new S3WarUploadEventToInvokeLambdaMaker().make(amazonS3Client, this.bucketName, stack);
        this.getLog().info((CharSequence)"Finished completing stack");
    }
}

