/*
 * Decompiled with CFR 0.152.
 */
package com.tvarit.plugin;

import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.tvarit.plugin.RolesFinder;
import com.tvarit.plugin.SubnetFinder;
import com.tvarit.plugin.VpcFinder;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class AsgParameterMaker {
    public List<Parameter> make(AmazonEC2Client amazonEC2Client, AmazonCloudFormationClient amazonCloudFormationClient, MavenProject project, String projectName, String lambdaCodeS3Key, String lambdaCodeS3Bucket) {
        RolesFinder rolesFinder = new RolesFinder(projectName, amazonCloudFormationClient);
        String tvaritRoleOutput = rolesFinder.findRoleArn();
        String tvaritInstanceProfileOutput = rolesFinder.findInstanceProfileArn();
        String vpcId = new VpcFinder().find(amazonEC2Client, projectName);
        StringBuilder publicSubnetIdBuilder = new StringBuilder();
        StringBuilder publicSubnetAzsBuilder = new StringBuilder();
        new SubnetFinder().find(project, amazonEC2Client, projectName, publicSubnetIdBuilder, publicSubnetAzsBuilder, "appSubnet");
        String publicSubnets = publicSubnetIdBuilder.toString();
        String publicSubnetAzs = publicSubnetAzsBuilder.toString();
        StringBuilder privateSubnetIdBuilder = new StringBuilder();
        StringBuilder privateSubnetAzsBuilder = new StringBuilder();
        new SubnetFinder().find(project, amazonEC2Client, projectName, privateSubnetIdBuilder, privateSubnetAzsBuilder, "db");
        String privateSubnets = privateSubnetIdBuilder.toString();
        String privateSubnetAzs = privateSubnetAzsBuilder.toString();
        Parameter projectNameParameter = new Parameter().withParameterKey("projectName").withParameterValue(projectName);
        Parameter publicSubnetsParameter = new Parameter().withParameterKey("publicSubnets").withParameterValue(publicSubnets);
        Parameter privateSubnetsParameter = new Parameter().withParameterKey("privateSubnets").withParameterValue(privateSubnets);
        Parameter availabilityZonesParameter = new Parameter().withParameterKey("availabilityZones").withParameterValue(publicSubnetAzs);
        Parameter vpcParameter = new Parameter().withParameterKey("vpc").withParameterValue(vpcId);
        Parameter healthCheckAbsoluteUrlParameter = new Parameter().withParameterKey("healthCheckAbsoluteUrl").withParameterValue("/tvarit/healthCheck.html");
        Parameter tvaritRoleParameter = new Parameter().withParameterKey("tvaritRoleArn").withParameterValue(tvaritRoleOutput);
        Parameter tvaritInstanceProfileParameter = new Parameter().withParameterKey("tvaritInstanceProfile").withParameterValue(tvaritInstanceProfileOutput);
        Parameter tvaritBucketNameParameter = new Parameter().withParameterKey("bucketName").withParameterValue("tvarit");
        Parameter tvaritLambdaCodeS3KeyParameter = new Parameter().withParameterKey("lambdaCodeS3Key").withParameterValue(lambdaCodeS3Key);
        Parameter tvaritLambdaCodeS3BucketParameter = new Parameter().withParameterKey("lambdaCodeS3Bucket").withParameterValue(lambdaCodeS3Bucket);
        return Arrays.asList(projectNameParameter, publicSubnetsParameter, privateSubnetsParameter, availabilityZonesParameter, vpcParameter, healthCheckAbsoluteUrlParameter, tvaritRoleParameter, tvaritInstanceProfileParameter, tvaritBucketNameParameter, tvaritLambdaCodeS3KeyParameter, tvaritLambdaCodeS3BucketParameter);
    }
}

