/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.watcher.matchers;

import io.fabric8.watcher.matchers.Matchers;
import java.nio.file.Path;
import java.nio.file.PathMatcher;

public class Logical {
    public static final String PREFIX = "log:";

    public static PathMatcher parse(String expression) {
        if (expression.startsWith(PREFIX)) {
            String log = expression.substring(PREFIX.length());
            return Logical.doParse(log);
        }
        throw new IllegalArgumentException("Expression does not start with the required prefix 'log:'");
    }

    private static PathMatcher doParse(String expression) {
        int i;
        if (!Logical.checkParenthesis(expression = expression.trim())) {
            throw new IllegalArgumentException("Not a matching number of '(' and ')' parenthesis: " + expression);
        }
        int index = 0;
        int start = -1;
        int[] tokens = new int[32];
        int token = 0;
        while (true) {
            int end;
            if (index >= expression.length()) {
                if (start < 0) break;
                end = index;
                tokens[token++] = start;
                tokens[token++] = end;
                break;
            }
            char c = expression.charAt(index);
            if (Character.isWhitespace(c)) {
                if (start >= 0) {
                    end = index;
                    tokens[token++] = start;
                    tokens[token++] = end;
                    start = -1;
                }
                ++index;
                continue;
            }
            if (c == '(') {
                if (start >= 0) {
                    end = index;
                    tokens[token++] = start;
                    tokens[token++] = end;
                    start = -1;
                    continue;
                }
                start = index;
                end = Logical.indexOfParenthesisMatch(expression, start);
                tokens[token++] = start + 1;
                tokens[token++] = end;
                start = -1;
                index = end + 1;
                continue;
            }
            if (start < 0) {
                start = index;
            }
            ++index;
        }
        for (i = 0; i < token; i += 2) {
            if (!expression.regionMatches(tokens[i], "or", 0, tokens[i + 1] - tokens[i])) continue;
            if (i == 0 || i > token - 2) {
                throw new IllegalArgumentException("Bad syntax: " + expression);
            }
            PathMatcher left = Logical.doParse(expression.substring(tokens[0], tokens[i - 1]));
            PathMatcher right = Logical.doParse(expression.substring(tokens[i + 2], tokens[token - 1]));
            return new OrMatcher(left, right);
        }
        for (i = 0; i < token; i += 2) {
            if (!expression.regionMatches(tokens[i], "and", 0, tokens[i + 1] - tokens[i])) continue;
            if (i == 0 || i > token - 2) {
                throw new IllegalArgumentException("Bad syntax: " + expression);
            }
            PathMatcher left = Logical.doParse(expression.substring(tokens[0], tokens[i - 1]));
            PathMatcher right = Logical.doParse(expression.substring(tokens[i + 2], tokens[token - 1]));
            return new AndMatcher(left, right);
        }
        if (token > 2 && expression.regionMatches(tokens[0], "not", 0, tokens[1] - tokens[0])) {
            PathMatcher right = Logical.doParse(expression.substring(tokens[2], tokens[token - 1]));
            return new NotMatcher(right);
        }
        if (!expression.matches("[a-z]+:.*")) {
            expression = "glob:" + expression;
        }
        return Matchers.parse(expression);
    }

    static boolean checkParenthesis(String str) {
        boolean result = true;
        if (str != null) {
            int open = 0;
            int closed = 0;
            int i = 0;
            while ((i = str.indexOf(40, i)) >= 0) {
                ++i;
                ++open;
            }
            i = 0;
            while ((i = str.indexOf(41, i)) >= 0) {
                ++i;
                ++closed;
            }
            result = open == closed;
        }
        return result;
    }

    public static int indexOfParenthesisMatch(String str, int first) {
        int index = -1;
        if (first < 0 || first > str.length()) {
            throw new IllegalArgumentException("Invalid position for first parenthesis: " + first);
        }
        if (str.charAt(first) != '(') {
            throw new IllegalArgumentException("character at indicated position is not a parenthesis");
        }
        int depth = 1;
        char[] array = str.toCharArray();
        for (index = first + 1; index < array.length; ++index) {
            char current = array[index];
            if (current == '(') {
                ++depth;
                continue;
            }
            if (current == ')' && --depth == 0) break;
        }
        if (depth != 0) {
            throw new IllegalArgumentException("Bad syntax: " + str);
        }
        return index;
    }

    static class NotMatcher
    implements PathMatcher {
        private final PathMatcher matcher;

        public NotMatcher(PathMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean matches(Path path) {
            return !this.matcher.matches(path);
        }
    }

    static class OrMatcher
    implements PathMatcher {
        private final PathMatcher left;
        private final PathMatcher right;

        OrMatcher(PathMatcher left, PathMatcher right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean matches(Path path) {
            return this.left.matches(path) || this.right.matches(path);
        }
    }

    static class AndMatcher
    implements PathMatcher {
        private final PathMatcher left;
        private final PathMatcher right;

        AndMatcher(PathMatcher left, PathMatcher right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean matches(Path path) {
            return this.left.matches(path) && this.right.matches(path);
        }
    }
}

