/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;

public class IOHelpers {
    protected static final int BUFFER_SIZE = 16384;

    public static void writeTo(File file, InputStream in) throws IOException {
        IOHelpers.writeTo(file, in, 16384);
    }

    public static void writeTo(File newFile, String text) throws IOException {
        IOHelpers.writeTo(newFile, new ByteArrayInputStream(text.getBytes()));
    }

    public static void writeTo(File file, InputStream in, int bufferSize) throws IOException {
        IOHelpers.writeTo(new FileOutputStream(file), in, bufferSize, true);
    }

    public static void writeTo(OutputStream outputStream, InputStream in, boolean close) throws IOException {
        IOHelpers.writeTo(outputStream, in, 16384, close);
    }

    public static void writeTo(OutputStream outputStream, InputStream in, int bufferSize, boolean close) throws IOException {
        int b;
        BufferedOutputStream out = new BufferedOutputStream(outputStream, bufferSize);
        BufferedInputStream bufferedIn = new BufferedInputStream(in, bufferSize);
        while ((b = bufferedIn.read()) >= 0) {
            out.write(b);
        }
        in.close();
        if (close) {
            out.close();
        } else {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
            outputStream.flush();
        }
        catch (Throwable throwable) {
            IOHelpers.close(inputStream, outputStream);
            throw throwable;
        }
        IOHelpers.close(inputStream, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader reader, Writer writer) throws IOException {
        try {
            int len;
            char[] buffer = new char[8192];
            while ((len = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, len);
            }
            writer.flush();
        }
        catch (Throwable throwable) {
            IOHelpers.close(reader, writer);
            throw throwable;
        }
        IOHelpers.close(reader, writer);
    }

    public static void close(ZipFile ... closeables) {
        for (ZipFile c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static String readFully(File file) throws IOException {
        if (!file.isFile()) {
            return null;
        }
        FileInputStream in = new FileInputStream(file);
        return IOHelpers.readFully(in);
    }

    public static String readFully(InputStream in) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        return IOHelpers.readFully(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader r) throws IOException {
        String string;
        StringWriter w = new StringWriter();
        try {
            IOHelpers.copy(r, w);
            string = w.toString();
        }
        catch (Throwable throwable) {
            IOHelpers.close(r, w);
            throw throwable;
        }
        IOHelpers.close(r, w);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFully(File file, String content) throws IOException {
        if (content == null) {
            file.delete();
            return;
        }
        StringReader r = new StringReader(content);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        try {
            IOHelpers.copy(r, w);
        }
        catch (Throwable throwable) {
            IOHelpers.close(r, w);
            throw throwable;
        }
        IOHelpers.close(r, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file) throws IOException {
        ArrayList<String> overrides = new ArrayList<String>();
        if (file.exists()) {
            FileInputStream is = new FileInputStream(file);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    overrides.add(line);
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return overrides;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, List<String> lines) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
            for (String over : lines) {
                writer.write(over);
                writer.newLine();
            }
            writer.close();
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFully(URL url) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        InputStream is = url.openStream();
        try {
            int l;
            while ((l = is.read(buf)) >= 0) {
                baos.write(buf, 0, l);
            }
        }
        finally {
            is.close();
        }
        return baos.toString();
    }
}

